/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.net.URI;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.rapi.InvalidProcessException;
import org.apache.ode.bpel.rtrep.v2.EvaluationContext;
import org.apache.ode.bpel.rtrep.v2.OElementVarType;
import org.apache.ode.bpel.rtrep.v2.OExpression;
import org.apache.ode.bpel.rtrep.v2.OLink;
import org.apache.ode.bpel.rtrep.v2.OMessageVarType;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BoundVariableEvaluationContext
implements EvaluationContext {
    private HashMap<String, Element> _boundVars = new HashMap();

    public void addBoundVariable(String name, Element value) {
        this._boundVars.put(name, value);
    }

    public Node readVariable(OScope.Variable variable, OMessageVarType.Part partDef) throws FaultException {
        Element data = this._boundVars.get(variable.name);
        if (data == null) {
            return null;
        }
        if (partDef != null) {
            Element part = DOMUtils.findChildByName((Element)data, (QName)new QName(null, partDef.name), (boolean)false);
            data = part != null && partDef.type instanceof OElementVarType ? DOMUtils.findChildByName((Element)part, (QName)((OElementVarType)partDef.type).elementType) : part;
        }
        return data;
    }

    public Node getPartData(Element message, OMessageVarType.Part part) throws FaultException {
        throw new InvalidProcessException("Part data not available in this context.");
    }

    public String readMessageProperty(OScope.Variable variable, OProcess.OProperty property) throws FaultException {
        throw new InvalidProcessException("Message property not available in this context.");
    }

    public boolean isLinkActive(OLink olink) throws FaultException {
        throw new InvalidProcessException("Links not available in this context.");
    }

    public Node getRootNode() {
        throw new InvalidProcessException("Root node not available in this context.");
    }

    public Node evaluateQuery(Node root, OExpression expr) throws FaultException {
        throw new InvalidProcessException("Root node querying not available in this context.");
    }

    public Long getProcessId() {
        throw new InvalidProcessException("Process id not available in this context.");
    }

    public boolean narrowTypes() {
        throw new InvalidProcessException("Types narrowing not available in this context.");
    }

    public URI getBaseResourceURI() {
        throw new InvalidProcessException("Base URI not available in this context.");
    }

    public Node getPropertyValue(QName propertyName) {
        throw new InvalidProcessException("Property value not available in this context.");
    }
}

