/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.rapi.OdeRTInstanceContext;
import org.apache.ode.bpel.rtrep.v2.ACTIVITYGUARD;
import org.apache.ode.bpel.rtrep.v2.ActivityInfo;
import org.apache.ode.bpel.rtrep.v2.CorrelationSetInstance;
import org.apache.ode.bpel.rtrep.v2.LinkFrame;
import org.apache.ode.bpel.rtrep.v2.OBase;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.bpel.rtrep.v2.OVarType;
import org.apache.ode.bpel.rtrep.v2.OdeInternalInstance;
import org.apache.ode.bpel.rtrep.v2.ScopeFrame;
import org.apache.ode.bpel.rtrep.v2.VariableInstance;
import org.apache.ode.bpel.rtrep.v2.channels.FaultData;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.vpu.JacobVPU;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BpelJacobRunnable
extends JacobRunnable {
    private static final Log __log = LogFactory.getLog(BpelJacobRunnable.class);
    protected ScopeFrame _scopeFrame;

    protected OdeInternalInstance getBpelRuntime() {
        OdeInternalInstance nativeApi = (OdeInternalInstance)JacobVPU.activeJacobThread().getExtension(OdeRTInstanceContext.class);
        assert (nativeApi != null);
        return nativeApi;
    }

    protected Log log() {
        return __log;
    }

    protected final FaultData createFault(QName fault, Element faultMsg, OVarType faultType, OBase location) {
        return new FaultData(fault, faultMsg, faultType, location);
    }

    protected final FaultData createFault(QName fault, OBase location, String faultExplanation) {
        return new FaultData(fault, location, faultExplanation);
    }

    protected final FaultData createFault(QName fault, OBase location) {
        return this.createFault(fault, location, null);
    }

    protected JacobRunnable createChild(ActivityInfo childInfo, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        return new ACTIVITYGUARD(childInfo, scopeFrame, linkFrame);
    }

    protected void initializeCorrelation(CorrelationSetInstance cset, VariableInstance variable) throws FaultException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Initializing correlation set " + cset.declaration.name));
        }
        if (this.getBpelRuntime().isCorrelationInitialized(cset)) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("OCorrelation set " + cset + " is already set: ignoring"));
            }
            throw new FaultException(cset.declaration.getOwner().constants.qnCorrelationViolation);
        }
        String[] propNames = new String[cset.declaration.properties.size()];
        String[] propValues = new String[cset.declaration.properties.size()];
        for (int i = 0; i < cset.declaration.properties.size(); ++i) {
            OProcess.OProperty property = cset.declaration.properties.get(i);
            propValues[i] = this.getBpelRuntime().readProperty(variable, property);
            propNames[i] = property.name.toString();
            if (!__log.isDebugEnabled()) continue;
            __log.debug((Object)("Setting correlation property " + propNames[i] + "=" + propValues[i]));
        }
        CorrelationKey ckeyVal = new CorrelationKey(cset.declaration.getId(), propValues);
        ckeyVal.setUnique(cset.declaration.isUnique());
        this.getBpelRuntime().writeCorrelation(cset, ckeyVal);
    }

    Node initializeVariable(VariableInstance var, Node val) throws ExternalVariableModuleException {
        return this.getBpelRuntime().initializeVariable(var, this._scopeFrame, val);
    }

    protected long genMonotonic() {
        return this.getBpelRuntime().genId();
    }
}

