/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.rapi.InvalidProcessException;
import org.apache.ode.bpel.rtrep.v2.ActivityInfo;
import org.apache.ode.bpel.rtrep.v2.BpelJacobRunnable;
import org.apache.ode.bpel.rtrep.v2.CompensationHandler;
import org.apache.ode.bpel.rtrep.v2.LinkFrame;
import org.apache.ode.bpel.rtrep.v2.OEventHandler;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.PartnerLinkInstance;
import org.apache.ode.bpel.rtrep.v2.SCOPE;
import org.apache.ode.bpel.rtrep.v2.ScopeFrame;
import org.apache.ode.bpel.rtrep.v2.Selector;
import org.apache.ode.bpel.rtrep.v2.VariableInstance;
import org.apache.ode.bpel.rtrep.v2.channels.EventHandlerControlChannel;
import org.apache.ode.bpel.rtrep.v2.channels.EventHandlerControlChannelListener;
import org.apache.ode.bpel.rtrep.v2.channels.FaultData;
import org.apache.ode.bpel.rtrep.v2.channels.ParentScopeChannel;
import org.apache.ode.bpel.rtrep.v2.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.rtrep.v2.channels.PickResponseChannel;
import org.apache.ode.bpel.rtrep.v2.channels.PickResponseChannelListener;
import org.apache.ode.bpel.rtrep.v2.channels.TerminationChannel;
import org.apache.ode.bpel.rtrep.v2.channels.TerminationChannelListener;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.SynchChannel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class EH_EVENT
extends BpelJacobRunnable {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(EH_EVENT.class);
    private EventHandlerControlChannel _ehc;
    private TerminationChannel _tc;
    private ParentScopeChannel _psc;
    private OEventHandler.OEvent _oevent;
    private Set<CompensationHandler> _comps = new HashSet<CompensationHandler>();
    private FaultData _fault;
    private Set<ActivityInfo> _active = new HashSet<ActivityInfo>();
    private boolean _stopped;
    private boolean _terminated;
    private boolean _childrenTerminated;

    EH_EVENT(ParentScopeChannel psc, TerminationChannel tc, EventHandlerControlChannel ehc, OEventHandler.OEvent o, ScopeFrame scopeFrame) {
        this._scopeFrame = scopeFrame;
        this._oevent = o;
        this._tc = tc;
        this._psc = psc;
        this._ehc = ehc;
    }

    public void run() {
        EH_EVENT.instance((JacobRunnable)new SELECT(this._scopeFrame));
    }

    private void terminateActive() {
        if (!this._childrenTerminated) {
            for (ActivityInfo tact : this._active) {
                ((TerminationChannel)EH_EVENT.replication((Channel)tact.self)).terminate();
            }
            this._childrenTerminated = true;
        }
    }

    private class WAITING
    extends BpelJacobRunnable {
        private static final long serialVersionUID = 1L;
        private PickResponseChannel _pickResponseChannel;

        private WAITING(PickResponseChannel pickResponseChannel, ScopeFrame scopeFrame) {
            this._pickResponseChannel = pickResponseChannel;
            this._scopeFrame = scopeFrame;
        }

        public void run() {
            if (!EH_EVENT.this._active.isEmpty() || this._pickResponseChannel != null) {
                HashSet<ChannelListener> mlset = new HashSet<ChannelListener>();
                if (!EH_EVENT.this._terminated) {
                    mlset.add(new TerminationChannelListener(EH_EVENT.this._tc){
                        private static final long serialVersionUID = 7666910462948788042L;

                        public void terminate() {
                            EH_EVENT.this.terminateActive();
                            EH_EVENT.this._terminated = true;
                            if (WAITING.this._pickResponseChannel != null) {
                                WAITING.this.getBpelRuntime().cancel(WAITING.this._pickResponseChannel);
                            }
                            1.instance((JacobRunnable)WAITING.this);
                        }
                    });
                }
                if (!EH_EVENT.this._stopped) {
                    mlset.add(new EventHandlerControlChannelListener(EH_EVENT.this._ehc){
                        private static final long serialVersionUID = -1050788954724647970L;

                        public void stop() {
                            EH_EVENT.this._stopped = true;
                            if (WAITING.this._pickResponseChannel != null) {
                                WAITING.this.getBpelRuntime().cancel(WAITING.this._pickResponseChannel);
                            }
                            2.instance((JacobRunnable)WAITING.this);
                        }
                    });
                }
                for (final ActivityInfo ai : EH_EVENT.this._active) {
                    mlset.add(new ParentScopeChannelListener(ai.parent){
                        private static final long serialVersionUID = 5341207762415360982L;

                        @Override
                        public void compensate(OScope scope, SynchChannel ret) {
                            EH_EVENT.this._psc.compensate(scope, ret);
                            3.instance((JacobRunnable)WAITING.this);
                        }

                        @Override
                        public void completed(FaultData faultData, Set<CompensationHandler> compensations) {
                            EH_EVENT.this._active.remove(ai);
                            EH_EVENT.this._comps.addAll(compensations);
                            if (faultData != null && EH_EVENT.this._fault == null) {
                                EH_EVENT.this._fault = faultData;
                                EH_EVENT.this.terminateActive();
                                EH_EVENT.this._psc.completed(EH_EVENT.this._fault, EH_EVENT.this._comps);
                            } else {
                                3.instance((JacobRunnable)WAITING.this);
                            }
                        }

                        @Override
                        public void cancelled() {
                            this.completed(null, CompensationHandler.emptySet());
                        }

                        @Override
                        public void failure(String reason, Element data) {
                            this.completed(null, CompensationHandler.emptySet());
                        }
                    });
                }
                if (this._pickResponseChannel != null) {
                    mlset.add(new PickResponseChannelListener(this._pickResponseChannel){
                        private static final long serialVersionUID = -4929999153478677288L;

                        public void onRequestRcvd(int selectorIdx, String mexId) {
                            Element msgEl;
                            ScopeFrame ehScopeFrame = new ScopeFrame((OScope)EH_EVENT.this._oevent, WAITING.this.getBpelRuntime().createScopeInstance(WAITING.this._scopeFrame.scopeInstanceId, EH_EVENT.this._oevent), WAITING.this._scopeFrame, (Set<CompensationHandler>)EH_EVENT.this._comps, EH_EVENT.this._fault);
                            if (((EH_EVENT)EH_EVENT.this)._oevent.variable != null && (msgEl = WAITING.this.getBpelRuntime().getMyRequest(mexId)) != null) {
                                try {
                                    VariableInstance vinst = ehScopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.variable);
                                    WAITING.this.initializeVariable(vinst, msgEl);
                                    VariableModificationEvent se = new VariableModificationEvent(vinst.declaration.name);
                                    se.setNewValue((Node)msgEl);
                                    WAITING.this._scopeFrame.fillEventInfo((ScopeEvent)se);
                                    if (((EH_EVENT)EH_EVENT.this)._oevent.debugInfo != null) {
                                        se.setLineNo(((EH_EVENT)EH_EVENT.this)._oevent.debugInfo.startLine);
                                    }
                                    WAITING.this.getBpelRuntime().sendEvent((ScopeEvent)se);
                                }
                                catch (Exception ex) {
                                    __log.fatal((Object)ex);
                                    throw new InvalidProcessException(ex);
                                }
                            }
                            try {
                                for (OScope.CorrelationSet cset : ((EH_EVENT)EH_EVENT.this)._oevent.initCorrelations) {
                                    WAITING.this.initializeCorrelation(ehScopeFrame.resolve(cset), ehScopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.variable));
                                }
                                if (((EH_EVENT)EH_EVENT.this)._oevent.partnerLink.hasPartnerRole()) {
                                    String partnersSessionId;
                                    Node fromEpr;
                                    if (!(WAITING.this.getBpelRuntime().isPartnerRoleEndpointInitialized(ehScopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.partnerLink)) && ((EH_EVENT)EH_EVENT.this)._oevent.partnerLink.initializePartnerRole || (fromEpr = WAITING.this.getBpelRuntime().getSourceEPR(mexId)) == null)) {
                                        WAITING.this.getBpelRuntime().writeEndpointReference(ehScopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.partnerLink), (Element)fromEpr);
                                    }
                                    if ((partnersSessionId = WAITING.this.getBpelRuntime().getSourceSessionId(mexId)) != null) {
                                        WAITING.this.getBpelRuntime().initializePartnersSessionId(ehScopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.partnerLink), partnersSessionId);
                                    }
                                }
                            }
                            catch (FaultException e) {
                                __log.error((Object)e);
                                if (EH_EVENT.this._fault == null) {
                                    EH_EVENT.this._fault = WAITING.this.createFault(e.getQName(), EH_EVENT.this._oevent);
                                    EH_EVENT.this.terminateActive();
                                }
                                4.instance((JacobRunnable)new WAITING(null, WAITING.this._scopeFrame));
                                return;
                            }
                            ActivityInfo child = new ActivityInfo(WAITING.this.genMonotonic(), ((EH_EVENT)EH_EVENT.this)._oevent.activity, (TerminationChannel)this.newChannel(TerminationChannel.class), (ParentScopeChannel)this.newChannel(ParentScopeChannel.class));
                            EH_EVENT.this._active.add(child);
                            LinkFrame lf = new LinkFrame(null);
                            4.instance((JacobRunnable)new SCOPE(child, ehScopeFrame, lf));
                            if (EH_EVENT.this._childrenTerminated) {
                                ((TerminationChannel)4.replication((Channel)child.self)).terminate();
                            }
                            if (EH_EVENT.this._terminated || EH_EVENT.this._stopped || EH_EVENT.this._fault != null) {
                                4.instance((JacobRunnable)new WAITING(null, WAITING.this._scopeFrame));
                            } else {
                                4.instance((JacobRunnable)new SELECT(WAITING.this._scopeFrame));
                            }
                        }

                        public void onTimeout() {
                            4.instance((JacobRunnable)new WAITING(null, WAITING.this._scopeFrame));
                        }

                        public void onCancel() {
                            4.instance((JacobRunnable)new WAITING(null, WAITING.this._scopeFrame));
                        }
                    });
                }
                WAITING.object((boolean)false, mlset);
            } else {
                EH_EVENT.this._psc.completed(EH_EVENT.this._fault, EH_EVENT.this._comps);
            }
        }
    }

    class SELECT
    extends BpelJacobRunnable {
        private static final long serialVersionUID = 1L;

        public SELECT(ScopeFrame scopeFrame) {
            this._scopeFrame = scopeFrame;
        }

        public void run() {
            try {
                CorrelationKey key;
                PickResponseChannel pickResponseChannel = (PickResponseChannel)this.newChannel(PickResponseChannel.class);
                PartnerLinkInstance pLinkInstance = this._scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.partnerLink);
                if (((EH_EVENT)EH_EVENT.this)._oevent.matchCorrelation == null) {
                    String sessionId = this.getBpelRuntime().fetchMySessionId(pLinkInstance);
                    key = new CorrelationKey(-1, new String[]{sessionId});
                } else {
                    if (!this.getBpelRuntime().isCorrelationInitialized(this._scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.matchCorrelation))) {
                        throw new FaultException(((EH_EVENT)EH_EVENT.this)._oevent.getOwner().constants.qnCorrelationViolation, "Correlation not initialized.");
                    }
                    key = this.getBpelRuntime().readCorrelation(this._scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.matchCorrelation));
                    assert (key != null);
                }
                Selector selector = new Selector(0, pLinkInstance, ((EH_EVENT)EH_EVENT.this)._oevent.operation.getName(), ((EH_EVENT)EH_EVENT.this)._oevent.operation.getOutput() == null, ((EH_EVENT)EH_EVENT.this)._oevent.messageExchangeId, key);
                this.getBpelRuntime().select(pickResponseChannel, null, false, new Selector[]{selector});
                SELECT.instance((JacobRunnable)new WAITING(pickResponseChannel, this._scopeFrame));
            }
            catch (FaultException e) {
                __log.error((Object)e);
                if (EH_EVENT.this._fault == null) {
                    EH_EVENT.this._fault = this.createFault(e.getQName(), EH_EVENT.this._oevent);
                }
                EH_EVENT.this.terminateActive();
                SELECT.instance((JacobRunnable)new WAITING(null, this._scopeFrame));
            }
        }
    }
}

