/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableReadEvent;
import org.apache.ode.bpel.rtrep.v2.CorrelationSetInstance;
import org.apache.ode.bpel.rtrep.v2.EvaluationContext;
import org.apache.ode.bpel.rtrep.v2.OConstantVarType;
import org.apache.ode.bpel.rtrep.v2.OExpression;
import org.apache.ode.bpel.rtrep.v2.OLink;
import org.apache.ode.bpel.rtrep.v2.OMessageVarType;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.bpel.rtrep.v2.OPropertyVarType;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.OdeInternalInstance;
import org.apache.ode.bpel.rtrep.v2.ScopeFrame;
import org.apache.ode.bpel.rtrep.v2.VariableInstance;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprEvaluationContextImpl
implements EvaluationContext {
    private static final Log __log = LogFactory.getLog(ExprEvaluationContextImpl.class);
    private OdeInternalInstance _native;
    private ScopeFrame _scopeInstance;
    private Map<OLink, Boolean> _linkVals;
    private Node _root;

    public ExprEvaluationContextImpl(ScopeFrame scopeInstace, OdeInternalInstance ntv) {
        this._native = ntv;
        this._scopeInstance = scopeInstace;
    }

    public ExprEvaluationContextImpl(ScopeFrame scopeInstace, OdeInternalInstance ntv, Node root) {
        this(scopeInstace, ntv);
        this._root = root;
    }

    public ExprEvaluationContextImpl(ScopeFrame scopeInstnce, OdeInternalInstance ntv, Map<OLink, Boolean> linkVals) {
        this(scopeInstnce, ntv);
        this._linkVals = linkVals;
    }

    @Override
    public Node readVariable(OScope.Variable variable, OMessageVarType.Part part) throws FaultException {
        Node ret;
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("readVariable(" + variable + "," + part + ")"));
        }
        if (variable.type instanceof OConstantVarType) {
            ret = ((OConstantVarType)variable.type).getValue();
        } else if (variable.type instanceof OPropertyVarType) {
            CorrelationSetInstance set = this._scopeInstance.resolve(variable.name);
            CorrelationKey key = this._native.readCorrelation(set);
            if (key == null) {
                return null;
            }
            String keyValue = key.getValues()[0];
            Document doc = DOMUtils.newDocument();
            ret = doc.createTextNode(keyValue);
        } else {
            VariableInstance varInstance = this._scopeInstance.resolve(variable);
            if (varInstance == null) {
                return null;
            }
            VariableReadEvent vre = new VariableReadEvent();
            vre.setVarName(varInstance.declaration.name);
            this.sendEvent((ScopeEvent)vre);
            ret = this._native.fetchVariableData(varInstance, this._scopeInstance, part, false);
        }
        return ret;
    }

    @Override
    public Node evaluateQuery(Node root, OExpression expr) throws FaultException {
        return this._native.getExpLangRuntime().evaluateNode(expr, new ExprEvaluationContextImpl(this._scopeInstance, this._native, root));
    }

    @Override
    public String readMessageProperty(OScope.Variable variable, OProcess.OProperty property) throws FaultException {
        VariableInstance varInstance = this._scopeInstance.resolve(variable);
        return this._native.readProperty(varInstance, property);
    }

    @Override
    public boolean isLinkActive(OLink olink) throws FaultException {
        return this._linkVals.get(olink);
    }

    public String toString() {
        return "{ExprEvaluationContextImpl scopeInstance=" + this._scopeInstance + ", activeLinks=" + this._linkVals + "}";
    }

    @Override
    public Node getRootNode() {
        return this._root;
    }

    @Override
    public Node getPartData(Element message, OMessageVarType.Part part) throws FaultException {
        return this._native.getPartData(message, part);
    }

    @Override
    public Long getProcessId() {
        return this._native.getPid();
    }

    @Override
    public boolean narrowTypes() {
        return true;
    }

    private void sendEvent(ScopeEvent se) {
        this._scopeInstance.fillEventInfo(se);
        this._native.sendEvent(se);
    }

    @Override
    public URI getBaseResourceURI() {
        return this._native.getBaseResourceURI();
    }

    @Override
    public Node getPropertyValue(QName propertyName) {
        return this._native.getProcessProperty(propertyName);
    }
}

