/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.rtrep.common.ConfigurationException;
import org.apache.ode.bpel.rtrep.v2.EvaluationContext;
import org.apache.ode.bpel.rtrep.v2.ExpressionLanguageRuntime;
import org.apache.ode.bpel.rtrep.v2.OExpression;
import org.apache.ode.bpel.rtrep.v2.OExpressionLanguage;
import org.apache.ode.utils.xsd.Duration;
import org.w3c.dom.Node;

public class ExpressionLanguageRuntimeRegistry {
    private final Map<OExpressionLanguage, ExpressionLanguageRuntime> _runtimes = new HashMap<OExpressionLanguage, ExpressionLanguageRuntime>();

    public void registerRuntime(OExpressionLanguage oelang) throws ConfigurationException {
        String className = oelang.properties.get("runtime-class");
        try {
            Class<?> cls = Class.forName(className);
            ExpressionLanguageRuntime elangRT = (ExpressionLanguageRuntime)cls.newInstance();
            elangRT.initialize(oelang.properties);
            this._runtimes.put(oelang, elangRT);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Illegal Access Error", e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Instantiation Error", e);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Class Not Found Error: " + className, e);
        }
    }

    public String evaluateAsString(OExpression cexp, EvaluationContext ctx) throws FaultException {
        try {
            return this.findRuntime(cexp).evaluateAsString(cexp, ctx);
        }
        catch (FaultException fe) {
            throw fe;
        }
        catch (Throwable t) {
            throw new FaultException(cexp.getOwner().constants.qnSubLanguageExecutionFault, t.toString(), t);
        }
    }

    public boolean evaluateAsBoolean(OExpression cexp, EvaluationContext ctx) throws FaultException {
        try {
            return this.findRuntime(cexp).evaluateAsBoolean(cexp, ctx);
        }
        catch (FaultException fe) {
            throw fe;
        }
        catch (Throwable t) {
            throw new FaultException(cexp.getOwner().constants.qnSubLanguageExecutionFault, t.toString(), t);
        }
    }

    public Number evaluateAsNumber(OExpression cexp, EvaluationContext ctx) throws FaultException {
        try {
            return this.findRuntime(cexp).evaluateAsNumber(cexp, ctx);
        }
        catch (FaultException fe) {
            throw fe;
        }
        catch (Throwable t) {
            throw new FaultException(cexp.getOwner().constants.qnSubLanguageExecutionFault, t.toString(), t);
        }
    }

    public List evaluate(OExpression cexp, EvaluationContext ctx) throws FaultException {
        try {
            return this.findRuntime(cexp).evaluate(cexp, ctx);
        }
        catch (FaultException fe) {
            throw fe;
        }
        catch (Throwable t) {
            throw new FaultException(cexp.getOwner().constants.qnSubLanguageExecutionFault, t.toString(), t);
        }
    }

    public Node evaluateNode(OExpression cexp, EvaluationContext ctx) throws FaultException {
        try {
            return this.findRuntime(cexp).evaluateNode(cexp, ctx);
        }
        catch (FaultException fe) {
            throw fe;
        }
        catch (Throwable t) {
            throw new FaultException(cexp.getOwner().constants.qnSubLanguageExecutionFault, t.toString(), t);
        }
    }

    public Calendar evaluateAsDate(OExpression cexp, EvaluationContext ctx) throws FaultException {
        try {
            return this.findRuntime(cexp).evaluateAsDate(cexp, ctx);
        }
        catch (FaultException fe) {
            throw fe;
        }
        catch (Throwable t) {
            throw new FaultException(cexp.getOwner().constants.qnSubLanguageExecutionFault, t.toString(), t);
        }
    }

    public Duration evaluateAsDuration(OExpression cexp, EvaluationContext ctx) throws FaultException {
        try {
            return this.findRuntime(cexp).evaluateAsDuration(cexp, ctx);
        }
        catch (FaultException fe) {
            throw fe;
        }
        catch (Throwable t) {
            throw new FaultException(cexp.getOwner().constants.qnSubLanguageExecutionFault, t.toString(), t);
        }
    }

    private ExpressionLanguageRuntime findRuntime(OExpression cexp) {
        return this._runtimes.get(cexp.expressionLanguage);
    }
}

