/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.rapi.ProcessModel;
import org.apache.ode.bpel.rtrep.common.extension.ExtensionContext;
import org.apache.ode.bpel.rtrep.v2.ActivityInfo;
import org.apache.ode.bpel.rtrep.v2.CompensationHandler;
import org.apache.ode.bpel.rtrep.v2.OActivity;
import org.apache.ode.bpel.rtrep.v2.OPartnerLink;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.OdeInternalInstance;
import org.apache.ode.bpel.rtrep.v2.PartnerLinkInstance;
import org.apache.ode.bpel.rtrep.v2.ScopeFrame;
import org.apache.ode.bpel.rtrep.v2.VariableInstance;
import org.apache.ode.bpel.rtrep.v2.channels.FaultData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionContextImpl
implements ExtensionContext {
    private static final Log __log = LogFactory.getLog(ExtensionContextImpl.class);
    private OdeInternalInstance _context;
    private ScopeFrame _scopeFrame;
    private ActivityInfo _activityInfo;
    private boolean hasCompleted = false;

    public ExtensionContextImpl(ActivityInfo activityInfo, ScopeFrame scopeFrame, OdeInternalInstance context) {
        this._activityInfo = activityInfo;
        this._context = context;
        this._scopeFrame = scopeFrame;
    }

    @Override
    public Long getProcessId() {
        return this._context.getPid();
    }

    @Override
    public Map<String, OScope.Variable> getVisibleVariables() throws FaultException {
        HashMap<String, OScope.Variable> visVars = new HashMap<String, OScope.Variable>();
        for (OActivity current = this._scopeFrame.oscope; current != null; current = current.getParent()) {
            if (!(current instanceof OScope)) continue;
            for (String varName : current.variables.keySet()) {
                if (visVars.containsKey(varName)) continue;
                visVars.put(varName, current.variables.get(varName));
            }
        }
        return visVars;
    }

    @Override
    public String readMessageProperty(OScope.Variable variable, OProcess.OProperty property) throws FaultException {
        VariableInstance vi = this._scopeFrame.resolve(variable);
        return this._context.readProperty(vi, property);
    }

    @Override
    public Node readVariable(OScope.Variable variable) throws FaultException {
        VariableInstance vi = this._scopeFrame.resolve(variable);
        return this._context.fetchVariableData(vi, this._scopeFrame, true);
    }

    @Override
    public void writeVariable(String variableName, Node value) throws FaultException, ExternalVariableModuleException {
        OScope.Variable var = this.getVisibleVariable(variableName);
        if (var == null) {
            throw new RuntimeException("Variable '" + variableName + "' not visible.");
        }
        this.writeVariable(var, value);
    }

    @Override
    public Node readVariable(String variableName) throws FaultException {
        OScope.Variable var = this.getVisibleVariable(variableName);
        if (var == null) {
            throw new RuntimeException("Variable '" + variableName + "' not visible.");
        }
        return this.readVariable(var);
    }

    @Override
    public void writeVariable(OScope.Variable variable, Node value) throws FaultException, ExternalVariableModuleException {
        VariableInstance vi = this._scopeFrame.resolve(variable);
        this._context.initializeVariable(vi, this._scopeFrame, value);
        this._context.commitChanges(vi, this._scopeFrame, value);
        VariableModificationEvent vme = new VariableModificationEvent(variable.name);
        vme.setNewValue(value);
        this.sendEvent((ScopeEvent)vme);
    }

    public OScope.Variable getVisibleVariable(String varName) {
        return this._scopeFrame.oscope.getVisibleVariable(varName);
    }

    @Override
    public boolean isVariableVisible(String varName) {
        return this._scopeFrame.oscope.getVisibleVariable(varName) != null;
    }

    @Override
    public String getActivityName() {
        return this._activityInfo.o.name;
    }

    @Override
    public OActivity getOActivity() {
        return this._activityInfo.o;
    }

    public void sendEvent(ScopeEvent event) {
        if (event.getLineNo() == -1 && this._activityInfo.o.debugInfo != null) {
            event.setLineNo(this._activityInfo.o.debugInfo.startLine);
        }
        this._scopeFrame.fillEventInfo(event);
        this._context.sendEvent(event);
    }

    @Override
    public void complete() {
        if (!this.hasCompleted) {
            this._activityInfo.parent.completed(null, CompensationHandler.emptySet());
            this.hasCompleted = true;
        } else if (__log.isWarnEnabled()) {
            __log.warn((Object)("Activity '" + this._activityInfo.o.name + "' has already been completed."));
        }
    }

    @Override
    public void completeWithFault(Throwable t) {
        if (!this.hasCompleted) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            FaultData fault = new FaultData(new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "subLanguageExecutionFault"), this._activityInfo.o, sw.getBuffer().toString());
            this._activityInfo.parent.completed(fault, CompensationHandler.emptySet());
            this.hasCompleted = true;
        } else if (__log.isWarnEnabled()) {
            __log.warn((Object)("Activity '" + this._activityInfo.o.name + "' has already been completed."));
        }
    }

    @Override
    public void completeWithFault(FaultException ex) {
        if (!this.hasCompleted) {
            FaultData fault = new FaultData(ex.getQName(), this._activityInfo.o, ex.getMessage());
            this._activityInfo.parent.completed(fault, CompensationHandler.emptySet());
            this.hasCompleted = true;
        } else if (__log.isWarnEnabled()) {
            __log.warn((Object)("Activity '" + this._activityInfo.o.name + "' has already been completed."));
        }
    }

    @Override
    public OdeInternalInstance getInternalInstance() {
        return this._context;
    }

    @Override
    public URI getDUDir() {
        return this._context.getBaseResourceURI();
    }

    @Override
    public void printToConsole(String msg) {
        LogFactory.getLog((String)"org.apache.ode.extension.Console").info((Object)msg);
    }

    @Override
    public PartnerLinkInstance getPartnerLinkInstance(String partnerLinkName) throws FaultException {
        OPartnerLink plink = this.getVisiblePartnerLink(partnerLinkName);
        if (plink == null) {
            throw new RuntimeException("PartnerLink '" + partnerLinkName + "' not visible.");
        }
        return this.getPartnerLinkInstance(plink);
    }

    public OPartnerLink getVisiblePartnerLink(String partnerLinkName) {
        return this._scopeFrame.oscope.getVisiblePartnerLink(partnerLinkName);
    }

    @Override
    public boolean isPartnerLinkVisible(String partnerLinkName) {
        return this._scopeFrame.oscope.getVisiblePartnerLink(partnerLinkName) != null;
    }

    @Override
    public PartnerLinkInstance getPartnerLinkInstance(OPartnerLink partnerLink) throws FaultException {
        return this._scopeFrame.resolve(partnerLink);
    }

    @Override
    public ProcessModel getProcessModel() {
        return this._context.getProcessModel();
    }
}

