/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.rtrep.v2.ACTIVITY;
import org.apache.ode.bpel.rtrep.v2.ActivityInfo;
import org.apache.ode.bpel.rtrep.v2.BpelJacobRunnable;
import org.apache.ode.bpel.rtrep.v2.ChildInfo;
import org.apache.ode.bpel.rtrep.v2.CompensationHandler;
import org.apache.ode.bpel.rtrep.v2.LinkFrame;
import org.apache.ode.bpel.rtrep.v2.OExpression;
import org.apache.ode.bpel.rtrep.v2.OForEach;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.SCOPE;
import org.apache.ode.bpel.rtrep.v2.ScopeFrame;
import org.apache.ode.bpel.rtrep.v2.VariableInstance;
import org.apache.ode.bpel.rtrep.v2.channels.FaultData;
import org.apache.ode.bpel.rtrep.v2.channels.ParentScopeChannel;
import org.apache.ode.bpel.rtrep.v2.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.rtrep.v2.channels.TerminationChannel;
import org.apache.ode.bpel.rtrep.v2.channels.TerminationChannelListener;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.SynchChannel;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.stl.FilterIterator;
import org.apache.ode.utils.stl.MemberOfFunction;
import org.apache.ode.utils.stl.UnaryFunction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOREACH
extends ACTIVITY {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(FOREACH.class);
    private OForEach _oforEach;
    private Set<ChildInfo> _children = new HashSet<ChildInfo>();
    private Set<CompensationHandler> _compHandlers = new HashSet<CompensationHandler>();
    private int _startCounter = -1;
    private int _finalCounter = -1;
    private int _currentCounter = -1;
    private int _completedCounter = 0;
    private int _completionCounter = -1;

    public FOREACH(ActivityInfo self, ScopeFrame frame, LinkFrame linkFrame) {
        super(self, frame, linkFrame);
        this._oforEach = (OForEach)self.o;
    }

    public void run() {
        try {
            this._startCounter = this.evaluateCondition(this._oforEach.startCounterValue);
            this._finalCounter = this.evaluateCondition(this._oforEach.finalCounterValue);
            if (this._oforEach.completionCondition != null) {
                this._completionCounter = this.evaluateCondition(this._oforEach.completionCondition.branchCount);
            }
            this._currentCounter = this._startCounter;
        }
        catch (FaultException fe) {
            __log.error((Object)fe);
            this._self.parent.completed(this.createFault(fe.getQName(), this._self.o), this._compHandlers);
            return;
        }
        if (this._completionCounter > 0 && this._completionCounter > this._finalCounter - this._startCounter) {
            this._self.parent.completed(this.createFault(this._oforEach.getOwner().constants.qnInvalidBranchCondition, this._self.o), this._compHandlers);
            return;
        }
        if (this._finalCounter < this._startCounter || this._completionCounter == 0) {
            this._self.parent.completed(null, this._compHandlers);
        } else {
            if (this._oforEach.parallel) {
                for (int m = this._startCounter; m <= this._finalCounter; ++m) {
                    this.newChild();
                }
            } else {
                this.newChild();
            }
            FOREACH.instance((JacobRunnable)new ACTIVE());
        }
    }

    private boolean shouldContinue() {
        boolean stop = false;
        if (this._completionCounter > 0) {
            stop = this._completedCounter >= this._completionCounter || stop;
        }
        stop = this._startCounter + this._completedCounter > this._finalCounter || stop;
        return !stop;
    }

    private int evaluateCondition(OExpression condition) throws FaultException {
        try {
            return this.getBpelRuntime().getExpLangRuntime().evaluateAsNumber(condition, this.getEvaluationContext()).intValue();
        }
        catch (FaultException e) {
            String msg = "ForEach counter value couldn't be evaluated as xs:unsignedInt.";
            __log.error((Object)msg, (Throwable)e);
            throw new FaultException(this._oforEach.getOwner().constants.qnForEachCounterError, msg, (Throwable)e);
        }
    }

    private void newChild() {
        ChildInfo child = new ChildInfo(new ActivityInfo(this.genMonotonic(), this._oforEach.innerScope, (TerminationChannel)this.newChannel(TerminationChannel.class), (ParentScopeChannel)this.newChannel(ParentScopeChannel.class)));
        this._children.add(child);
        Document doc = DOMUtils.newDocument();
        Text counterNode = doc.createTextNode("" + this._currentCounter++);
        ScopeFrame newFrame = new ScopeFrame(this._oforEach.innerScope, this.getBpelRuntime().createScopeInstance(this._scopeFrame.scopeInstanceId, this._oforEach.innerScope), this._scopeFrame, null);
        VariableInstance vinst = newFrame.resolve(this._oforEach.counterVariable);
        try {
            this.initializeVariable(vinst, counterNode);
        }
        catch (ExternalVariableModuleException e) {
            __log.error((Object)"Exception while initializing external variable", (Throwable)e);
            this._self.parent.failure(e.toString(), null);
            return;
        }
        VariableModificationEvent se = new VariableModificationEvent(vinst.declaration.name);
        se.setNewValue((Node)counterNode);
        if (this._oforEach.debugInfo != null) {
            se.setLineNo(this._oforEach.debugInfo.startLine);
        }
        this.sendEvent((ScopeEvent)se);
        FOREACH.instance((JacobRunnable)new SCOPE(child.activity, newFrame, this._linkFrame));
    }

    public String toString() {
        return "<T:Act:Flow:" + this._oforEach.name + ">";
    }

    private Iterator<ChildInfo> active() {
        return new FilterIterator(this._children.iterator(), (UnaryFunction)new MemberOfFunction<ChildInfo>(){

            public boolean isMember(ChildInfo childInfo) {
                return !childInfo.completed;
            }
        });
    }

    private class ACTIVE
    extends BpelJacobRunnable {
        private static final long serialVersionUID = -5642862698981385732L;
        private FaultData _fault;
        private boolean _terminateRequested = false;

        private ACTIVE() {
        }

        public void run() {
            Iterator active = FOREACH.this.active();
            if (FOREACH.this.active().hasNext()) {
                HashSet<ChannelListener> mlSet = new HashSet<ChannelListener>();
                mlSet.add(new TerminationChannelListener(FOREACH.this._self.self){
                    private static final long serialVersionUID = 2554750257484084466L;

                    public void terminate() {
                        Iterator i = FOREACH.this.active();
                        while (i.hasNext()) {
                            ((TerminationChannel)1.replication((Channel)((ChildInfo)i.next()).activity.self)).terminate();
                        }
                        ACTIVE.this._terminateRequested = true;
                        1.instance((JacobRunnable)ACTIVE.this);
                    }
                });
                while (active.hasNext()) {
                    final ChildInfo child = (ChildInfo)active.next();
                    mlSet.add(new ParentScopeChannelListener(child.activity.parent){
                        private static final long serialVersionUID = -8027205709961438172L;

                        @Override
                        public void compensate(OScope scope, SynchChannel ret) {
                            FOREACH.this._self.parent.compensate(scope, ret);
                            2.instance((JacobRunnable)ACTIVE.this);
                        }

                        @Override
                        public void completed(FaultData faultData, Set<CompensationHandler> compensations) {
                            child.completed = true;
                            if (FOREACH.this._completionCounter > 0 && ((FOREACH)FOREACH.this)._oforEach.completionCondition.successfulBranchesOnly) {
                                if (faultData != null) {
                                    FOREACH.this._completedCounter++;
                                }
                            } else {
                                FOREACH.this._completedCounter++;
                            }
                            FOREACH.this._compHandlers.addAll(compensations);
                            if (faultData != null && ACTIVE.this._fault == null) {
                                ACTIVE.this._fault = faultData;
                            }
                            if (FOREACH.this.shouldContinue() && ACTIVE.this._fault == null && !ACTIVE.this._terminateRequested) {
                                if (!((FOREACH)FOREACH.this)._oforEach.parallel) {
                                    FOREACH.this.newChild();
                                }
                            } else {
                                Iterator i = FOREACH.this.active();
                                while (i.hasNext()) {
                                    ((TerminationChannel)2.replication((Channel)((ChildInfo)i.next()).activity.self)).terminate();
                                }
                            }
                            2.instance((JacobRunnable)ACTIVE.this);
                        }

                        @Override
                        public void cancelled() {
                            this.completed(null, CompensationHandler.emptySet());
                        }

                        @Override
                        public void failure(String reason, Element data) {
                            this.completed(null, CompensationHandler.emptySet());
                        }
                    });
                }
                ACTIVE.object((boolean)false, mlSet);
            } else {
                FOREACH.this._self.parent.completed(this._fault, FOREACH.this._compHandlers);
            }
        }
    }
}

