/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.rtrep.v2.OActivity;
import org.apache.ode.bpel.rtrep.v2.OBase;
import org.apache.ode.bpel.rtrep.v2.OExpression;
import org.apache.ode.bpel.rtrep.v2.OLValueExpression;
import org.apache.ode.bpel.rtrep.v2.OMessageVarType;
import org.apache.ode.bpel.rtrep.v2.OPartnerLink;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.SerializableElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OAssign
extends OActivity {
    static final long serialVersionUID = -1L;
    public final List<OAssignOperation> operations = new ArrayList<OAssignOperation>();

    public OAssign(OProcess owner, OActivity parent) {
        super(owner, parent);
    }

    public String toString() {
        return "{OAssign : " + this.name + ", joinCondition=" + this.joinCondition + "}";
    }

    public static class PartnerLinkRef
    extends OBase
    implements RValue,
    LValue {
        private static final long serialVersionUID = 1L;
        public OPartnerLink partnerLink;
        public boolean isMyEndpointReference;

        public PartnerLinkRef(OProcess owner) {
            super(owner);
        }

        public OScope.Variable getVariable() {
            return null;
        }

        public String toString() {
            return "{PLinkRef " + this.partnerLink + "!" + this.isMyEndpointReference + "}";
        }
    }

    public static class PropertyRef
    extends OBase
    implements RValue,
    LValue {
        private static final long serialVersionUID = 1L;
        public OScope.Variable variable;
        public OProcess.OPropertyAlias propertyAlias;

        public PropertyRef(OProcess owner) {
            super(owner);
        }

        public OScope.Variable getVariable() {
            return this.variable;
        }

        public String toString() {
            return "{PropRef " + this.variable + "!" + this.propertyAlias + "}";
        }
    }

    public static class VariableRef
    extends OBase
    implements RValue,
    LValue {
        private static final long serialVersionUID = 1L;
        public OScope.Variable variable;
        public OMessageVarType.Part part;
        public OMessageVarType.Part headerPart;
        public OExpression location;

        public VariableRef(OProcess owner) {
            super(owner);
        }

        public OScope.Variable getVariable() {
            return this.variable;
        }

        public boolean isMessageRef() {
            return this.variable.type instanceof OMessageVarType && this.part == null && this.headerPart == null && this.location == null;
        }

        public boolean isPartRef() {
            return this.variable.type instanceof OMessageVarType && this.part != null && this.location == null;
        }

        public boolean isHeaderRef() {
            return this.variable.type instanceof OMessageVarType && this.headerPart != null && this.location == null;
        }

        public String toString() {
            return "{VarRef " + this.variable + (this.part == null ? "" : "." + this.part.name) + (this.location == null ? "" : this.location.toString()) + "}";
        }
    }

    public static class DirectRef
    extends OBase
    implements RValue,
    LValue {
        private static final long serialVersionUID = 1L;
        public OScope.Variable variable;
        public QName elName;

        public DirectRef(OProcess owner) {
            super(owner);
        }

        public OScope.Variable getVariable() {
            return this.variable;
        }
    }

    public static class Expression
    extends OBase
    implements RValue {
        private static final long serialVersionUID = 1L;
        public OExpression expression;

        public Expression(OProcess owner, OExpression compiledExpression) {
            super(owner);
            this.expression = compiledExpression;
        }

        public String toString() {
            return this.expression.toString();
        }
    }

    public static class LValueExpression
    extends OBase
    implements LValue {
        private static final long serialVersionUID = 1L;
        public OLValueExpression expression;

        public LValueExpression(OProcess owner, OLValueExpression compiledExpression) {
            super(owner);
            this.expression = compiledExpression;
        }

        public String toString() {
            return this.expression.toString();
        }

        public OScope.Variable getVariable() {
            return this.expression.getVariable();
        }

        public boolean isInsertMissingToData() {
            return this.expression.insertMissingData;
        }

        public void setInsertMissingToData(boolean insertMissingToData) {
            this.expression.insertMissingData = insertMissingToData;
        }
    }

    public static class Literal
    extends OBase
    implements RValue {
        private static final long serialVersionUID = 1L;
        public transient Document xmlLiteral;

        public Literal(OProcess owner, Document xmlLiteral) {
            super(owner);
            if (xmlLiteral == null) {
                throw new IllegalArgumentException("null xmlLiteral!");
            }
            this.xmlLiteral = xmlLiteral;
        }

        public String toString() {
            return "{Literal " + DOMUtils.domToString((Node)this.xmlLiteral) + "}";
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(DOMUtils.domToString((Node)this.xmlLiteral));
        }

        private void readObject(ObjectInputStream in) throws IOException {
            String domStr;
            try {
                domStr = (String)in.readObject();
            }
            catch (ClassNotFoundException e) {
                throw (IOException)new IOException("XML de-serialization error.").initCause(e);
            }
            try {
                this.xmlLiteral = DOMUtils.stringToDOM((String)domStr).getOwnerDocument();
            }
            catch (Exception ex) {
                throw (IOException)new IOException("XML de-serialization error.").initCause(ex);
            }
        }

        public Document getXmlLiteral() {
            Element literalRoot = this.xmlLiteral.getDocumentElement();
            Document copyDoc = DOMUtils.newDocument();
            Node copyElmt = copyDoc.importNode(literalRoot, true);
            copyDoc.appendChild(copyElmt);
            return copyDoc;
        }
    }

    public static interface RValue {
    }

    public static interface LValue {
        public OScope.Variable getVariable();
    }

    public static class ExtensionAssignOperation
    extends OAssignOperation {
        private static final long serialVersionUID = 1L;
        public SerializableElement nestedElement;
        public QName extensionName;

        public ExtensionAssignOperation(OProcess owner) {
            super(owner);
        }

        public String toString() {
            return "{OExtensionAssignOperation; " + this.nestedElement.getElement().getTagName() + "}";
        }

        public OAssignOperation.Type getType() {
            return OAssignOperation.Type.ExtensionOperation;
        }
    }

    public static class Copy
    extends OAssignOperation {
        private static final long serialVersionUID = 1L;
        public LValue to;
        public RValue from;
        public boolean keepSrcElementName;
        public boolean ignoreMissingFromData;
        public boolean ignoreUninitializedFromVariable;
        public boolean insertMissingToData;

        public Copy(OProcess owner) {
            super(owner);
        }

        public String toString() {
            return "{OCopy " + this.to + "=" + this.from + "}";
        }

        public OAssignOperation.Type getType() {
            return OAssignOperation.Type.Copy;
        }
    }

    public static abstract class OAssignOperation
    extends OBase {
        public OAssignOperation(OProcess owner) {
            super(owner);
        }

        public abstract Type getType();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            Copy,
            ExtensionOperation;

        }
    }
}

