/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.rapi.ActivityModel;
import org.apache.ode.bpel.rapi.ConstantsModel;
import org.apache.ode.bpel.rapi.PartnerLinkModel;
import org.apache.ode.bpel.rapi.ProcessModel;
import org.apache.ode.bpel.rapi.PropertyAliasModel;
import org.apache.ode.bpel.rapi.ScopeModel;
import org.apache.ode.bpel.rtrep.v2.OBase;
import org.apache.ode.bpel.rtrep.v2.OConstants;
import org.apache.ode.bpel.rtrep.v2.OElementVarType;
import org.apache.ode.bpel.rtrep.v2.OExpression;
import org.apache.ode.bpel.rtrep.v2.OExpressionLanguage;
import org.apache.ode.bpel.rtrep.v2.OMessageVarType;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.OVarType;
import org.apache.ode.bpel.rtrep.v2.OXsdTypeVarType;
import org.apache.ode.bpel.rtrep.v2.OXslSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OProcess
extends OBase
implements ProcessModel {
    public static int instanceCount = 0;
    static final long serialVersionUID = -1L;
    public String guid;
    public final String version;
    public OConstants constants;
    public String uuid;
    public String targetNamespace;
    public String processName;
    public OScope processScope;
    public boolean atomicScope;
    public final Set<PartnerLinkModel> allPartnerLinks = new HashSet<PartnerLinkModel>();
    public final List<OProperty> properties = new ArrayList<OProperty>();
    public final Set<OExtension> declaredExtensions = new HashSet<OExtension>();
    public final Set<OExtension> mustUnderstandExtensions = new HashSet<OExtension>();
    public Date compileDate;
    public byte[] globalState;
    int _childIdCounter = 0;
    List<OBase> _children = new ArrayList<OBase>();
    public final HashSet<OExpressionLanguage> expressionLanguages = new HashSet();
    public final HashMap<QName, OMessageVarType> messageTypes = new HashMap();
    public final HashMap<QName, OElementVarType> elementTypes = new HashMap();
    public final HashMap<QName, OXsdTypeVarType> xsdTypes = new HashMap();
    public final HashMap<URI, OXslSheet> xslSheets = new HashMap();

    public OProcess(String bpelVersion) {
        super(null);
        this.version = bpelVersion;
        ++instanceCount;
    }

    public String getGuid() {
        return this.guid;
    }

    public ActivityModel getChild(int id) {
        for (int i = this._children.size() - 1; i >= 0; --i) {
            OBase child = this._children.get(i);
            if (child.getId() != id) continue;
            return child;
        }
        return null;
    }

    public List<OBase> getChildren() {
        return this._children;
    }

    public OScope getScope(String scopeName) {
        throw new UnsupportedOperationException();
    }

    public Set<PartnerLinkModel> getAllPartnerLinks() {
        return Collections.unmodifiableSet(this.allPartnerLinks);
    }

    public PartnerLinkModel getPartnerLink(String name) {
        for (PartnerLinkModel partnerLink : this.allPartnerLinks) {
            if (!partnerLink.getName().equals(name)) continue;
            return partnerLink;
        }
        return null;
    }

    public PartnerLinkModel getPartnerLink(int partnerLinkModelId) {
        return (PartnerLinkModel)this.getChild(partnerLinkModelId);
    }

    public String getName() {
        return this.processName;
    }

    public Collection getExpressionLanguages() {
        throw new UnsupportedOperationException();
    }

    public List<String> getCorrelators() {
        ArrayList<String> correlators = new ArrayList<String>();
        for (PartnerLinkModel plink : this.getAllPartnerLinks()) {
            if (!plink.hasMyRole()) continue;
            for (Operation op : plink.getMyRolePortType().getOperations()) {
                correlators.add(plink.getId() + "." + op.getName());
            }
        }
        return correlators;
    }

    public QName getQName() {
        return new QName(this.targetNamespace, this.processName);
    }

    protected void finalize() throws Throwable {
        --instanceCount;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        ++instanceCount;
    }

    public int getModelVersion() {
        return 2;
    }

    public ConstantsModel getConstantsModel() {
        return new ConstantsModel(){

            public QName getConflictingReceive() {
                return OProcess.this.constants.qnConflictingReceive;
            }

            public QName getCorrelationViolation() {
                return OProcess.this.constants.qnCorrelationViolation;
            }

            public QName getDuplicateInstance() {
                return OProcess.this.constants.qnDuplicateInstance;
            }

            public QName getForEachCounterError() {
                return OProcess.this.constants.qnForEachCounterError;
            }

            public QName getForcedTermination() {
                return OProcess.this.constants.qnForcedTermination;
            }

            public QName getInvalidBranchCondition() {
                return OProcess.this.constants.qnInvalidBranchCondition;
            }

            public QName getInvalidExpressionValue() {
                return OProcess.this.constants.qnInvalidExpressionValue;
            }

            public QName getJoinFailure() {
                return OProcess.this.constants.qnJoinFailure;
            }

            public QName getMismatchedAssignmentFailure() {
                return OProcess.this.constants.qnMismatchedAssignmentFailure;
            }

            public QName getMissingReply() {
                return OProcess.this.constants.qnMissingReply;
            }

            public QName getMissingRequest() {
                return OProcess.this.constants.qnMissingRequest;
            }

            public QName getRetiredProcess() {
                return OProcess.this.constants.qnRetiredProcess;
            }

            public QName getSelectionFailure() {
                return OProcess.this.constants.qnSelectionFailure;
            }

            public QName getSubLanguageExecutionFault() {
                return OProcess.this.constants.qnSubLanguageExecutionFault;
            }

            public QName getUninitializedPartnerRole() {
                return OProcess.this.constants.qnUninitializedPartnerRole;
            }

            public QName getUninitializedVariable() {
                return OProcess.this.constants.qnUninitializedVariable;
            }

            public QName getUnknownFault() {
                return OProcess.this.constants.qnUnknownFault;
            }

            public QName getXsltInvalidSource() {
                return OProcess.this.constants.qnXsltInvalidSource;
            }
        };
    }

    public ScopeModel getProcessScope() {
        return this.processScope;
    }

    public static class OExtension
    extends OBase {
        static final long serialVersionUID = -1L;
        public String namespaceURI;
        public boolean mustUnderstand;

        public OExtension(OProcess process) {
            super(process);
        }

        public String toString() {
            return "{OExtension " + this.namespaceURI + (this.mustUnderstand ? " mustUnderstand" : "") + "}";
        }
    }

    public static class OPropertyAlias
    extends OBase
    implements PropertyAliasModel {
        static final long serialVersionUID = -1L;
        public OVarType varType;
        public OMessageVarType.Part part;
        public OExpression location;

        public OPropertyAlias(OProcess owner) {
            super(owner);
        }

        public String toString() {
            return "{OPropertyAlias " + this.getDescription() + "}";
        }

        public String getDescription() {
            StringBuffer buf = new StringBuffer(this.varType.toString());
            buf.append('[');
            buf.append(this.part != null ? this.part.name : "");
            if (this.location != null) {
                buf.append("][");
                buf.append(this.location.toString());
            }
            buf.append(']');
            return buf.toString();
        }
    }

    public static class OProperty
    extends OBase {
        static final long serialVersionUID = -1L;
        public final List<OPropertyAlias> aliases = new ArrayList<OPropertyAlias>();
        public QName name;

        public OProperty(OProcess process) {
            super(process);
        }

        public OPropertyAlias getAlias(OVarType messageType) {
            for (OPropertyAlias aliase : this.aliases) {
                if (!aliase.varType.equals(messageType)) continue;
                return aliase;
            }
            return null;
        }

        public String toString() {
            return "{OProperty " + this.name + "}";
        }
    }
}

