/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.rapi.ActivityModel;
import org.apache.ode.bpel.rapi.CorrelationSetModel;
import org.apache.ode.bpel.rapi.PropertyAliasModel;
import org.apache.ode.bpel.rapi.PropertyExtractor;
import org.apache.ode.bpel.rapi.ScopeModel;
import org.apache.ode.bpel.rtrep.v2.OActivity;
import org.apache.ode.bpel.rtrep.v2.OBase;
import org.apache.ode.bpel.rtrep.v2.OCompensationHandler;
import org.apache.ode.bpel.rtrep.v2.OEventHandler;
import org.apache.ode.bpel.rtrep.v2.OExtVar;
import org.apache.ode.bpel.rtrep.v2.OFaultHandler;
import org.apache.ode.bpel.rtrep.v2.OPartnerLink;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.bpel.rtrep.v2.OTerminationHandler;
import org.apache.ode.bpel.rtrep.v2.OVarType;

public class OScope
extends OActivity
implements ScopeModel {
    static final long serialVersionUID = -1L;
    public String name;
    public OFaultHandler faultHandler;
    public OActivity activity;
    public OCompensationHandler compensationHandler;
    public OTerminationHandler terminationHandler;
    public OEventHandler eventHandler;
    public final HashMap<String, Variable> variables = new HashMap();
    public final Map<String, CorrelationSet> correlationSets = new HashMap<String, CorrelationSet>();
    public final Map<String, OPartnerLink> partnerLinks = new HashMap<String, OPartnerLink>();
    public final Set<OScope> compensatable = new HashSet<OScope>();
    public boolean implicitScope;
    public boolean atomicScope;
    public boolean isolatedScope;
    public boolean inboundMessageChildActivity;

    public OScope(OProcess owner, OActivity parent) {
        super(owner, parent);
    }

    public CorrelationSet getCorrelationSet(String corrName) {
        return this.correlationSets.get(corrName);
    }

    public Variable getLocalVariable(String varName) {
        return this.variables.get(varName);
    }

    public void addLocalVariable(Variable variable) {
        this.variables.put(variable.name, variable);
    }

    public Variable getVisibleVariable(String varName) {
        for (OActivity current = this; current != null; current = current.getParent()) {
            Variable variable;
            if (!(current instanceof OScope) || (variable = current.getLocalVariable(varName)) == null) continue;
            return variable;
        }
        return null;
    }

    public OPartnerLink getLocalPartnerLink(String name) {
        return this.partnerLinks.get(name);
    }

    public OPartnerLink getVisiblePartnerLink(String name) {
        for (OActivity current = this; current != null; current = current.getParent()) {
            OPartnerLink plink;
            if (!(current instanceof OScope) || (plink = current.getLocalPartnerLink(name)) == null) continue;
            return plink;
        }
        return null;
    }

    public void addCorrelationSet(CorrelationSet ocset) {
        this.correlationSets.put(ocset.name, ocset);
    }

    public boolean isInAtomicScope() {
        for (OActivity current = this; current != null; current = current.getParent()) {
            if (!(current instanceof OScope) || !current.atomicScope) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "{OScope '" + this.name + "' id=" + this.getId() + "}";
    }

    public ActivityModel getActivity() {
        return this.activity;
    }

    public static final class Variable
    extends OBase {
        static final long serialVersionUID = -1L;
        public String name;
        public OScope declaringScope;
        public OVarType type;
        public OExtVar extVar;

        public Variable(OProcess owner, OVarType type) {
            super(owner);
            this.type = type;
        }

        public String toString() {
            return "{Variable " + this.getDescription() + ":" + this.type + "}";
        }

        public String getDescription() {
            StringBuffer buf = new StringBuffer(this.declaringScope.name);
            buf.append('.');
            buf.append(this.name);
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CorrelationSet
    extends OBase
    implements CorrelationSetModel {
        static final long serialVersionUID = -1L;
        public String name;
        public OScope declaringScope;
        public final List<OProcess.OProperty> properties = new ArrayList<OProcess.OProperty>();
        public final List<PropertyExtractor> extractors = new ArrayList<PropertyExtractor>();
        public boolean unique;

        public CorrelationSet(OProcess owner) {
            super(owner);
        }

        @Override
        public String toString() {
            return "{CSet " + this.name + " " + this.properties + "}";
        }

        public List<PropertyAliasModel> getAliases(QName messageName) {
            ArrayList<PropertyAliasModel> aliases = new ArrayList<PropertyAliasModel>();
            OVarType messageType = this.getOwner().messageTypes.get(messageName);
            for (OProcess.OProperty prop : this.properties) {
                OProcess.OProperty property = prop;
                OProcess.OPropertyAlias alias = property.getAlias(messageType);
                if (alias == null) {
                    throw new IllegalArgumentException("No alias found for property " + property.name + " and message " + messageName + ", should have been caught at compilation.");
                }
                aliases.add(alias);
            }
            return aliases;
        }

        public List<PropertyExtractor> getExtractors() {
            return this.extractors;
        }

        public boolean isUnique() {
            return this.unique;
        }

        public void setUnique(boolean unique) {
            this.unique = unique;
        }
    }
}

