/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.util.Set;
import org.apache.ode.bpel.evt.ProcessInstanceStartedEvent;
import org.apache.ode.bpel.rtrep.v2.ActivityInfo;
import org.apache.ode.bpel.rtrep.v2.BpelJacobRunnable;
import org.apache.ode.bpel.rtrep.v2.CompensationHandler;
import org.apache.ode.bpel.rtrep.v2.InstanceGlobals;
import org.apache.ode.bpel.rtrep.v2.LinkFrame;
import org.apache.ode.bpel.rtrep.v2.OBase;
import org.apache.ode.bpel.rtrep.v2.OFailureHandling;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.OdeInternalInstance;
import org.apache.ode.bpel.rtrep.v2.READWRITELOCK;
import org.apache.ode.bpel.rtrep.v2.SCOPE;
import org.apache.ode.bpel.rtrep.v2.ScopeFrame;
import org.apache.ode.bpel.rtrep.v2.channels.FaultData;
import org.apache.ode.bpel.rtrep.v2.channels.ParentScopeChannel;
import org.apache.ode.bpel.rtrep.v2.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.rtrep.v2.channels.ReadWriteLockChannel;
import org.apache.ode.bpel.rtrep.v2.channels.TerminationChannel;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.SynchChannel;
import org.w3c.dom.Element;

public class PROCESS
extends BpelJacobRunnable {
    private static final long serialVersionUID = 1L;
    private OProcess _oprocess;
    private InstanceGlobals _globals;

    public PROCESS(OProcess process) {
        this._oprocess = process;
    }

    public void run() {
        OdeInternalInstance ntive = this.getBpelRuntime();
        Long scopeInstanceId = ntive.createScopeInstance(null, this._oprocess.processScope);
        this.createGlobals();
        ProcessInstanceStartedEvent evt = new ProcessInstanceStartedEvent();
        evt.setRootScopeId(scopeInstanceId);
        evt.setScopeDeclarationId(this._oprocess.processScope.getId());
        ntive.sendEvent(evt);
        ActivityInfo child = new ActivityInfo(this.genMonotonic(), this._oprocess.processScope, (TerminationChannel)this.newChannel(TerminationChannel.class), (ParentScopeChannel)this.newChannel(ParentScopeChannel.class));
        ScopeFrame processFrame = new ScopeFrame(this._oprocess.processScope, scopeInstanceId, null, null, this._globals);
        PROCESS.instance((JacobRunnable)new SCOPE(child, processFrame, new LinkFrame(null)));
        PROCESS.object((ChannelListener)new ParentScopeChannelListener(child.parent){
            private static final long serialVersionUID = -8564969578471906493L;

            @Override
            public void compensate(OScope scope, SynchChannel ret) {
                assert (false);
            }

            @Override
            public void completed(FaultData fault, Set<CompensationHandler> compensations) {
                OdeInternalInstance nativeAPI = PROCESS.this.getBpelRuntime();
                if (fault == null) {
                    nativeAPI.completedOk();
                } else {
                    nativeAPI.completedFault(fault);
                }
            }

            @Override
            public void cancelled() {
                this.completed(null, CompensationHandler.emptySet());
            }

            @Override
            public void failure(String reason, Element data) {
                FaultData faultData = PROCESS.this.createFault(OFailureHandling.FAILURE_FAULT_NAME, PROCESS.this._oprocess, reason);
                this.completed(faultData, CompensationHandler.emptySet());
            }
        });
    }

    private void createGlobals() {
        this._globals = new InstanceGlobals();
        for (OBase child : this._oprocess.getChildren()) {
            if (!(child instanceof OScope.Variable)) continue;
            OScope.Variable var = (OScope.Variable)child;
            ReadWriteLockChannel vlock = (ReadWriteLockChannel)this.newChannel(ReadWriteLockChannel.class);
            PROCESS.instance((JacobRunnable)new READWRITELOCK(vlock));
            this._globals._varLocks.put(var, vlock);
        }
    }
}

