/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2.xpath10;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.rtrep.v2.OXslSheet;
import org.apache.ode.bpel.rtrep.v2.xpath10.OXPath10Expression;
import org.apache.ode.utils.StreamUtils;
import org.apache.ode.utils.fs.FileUtils;

public class XslRuntimeUriResolver
implements URIResolver {
    private static final Log __log = LogFactory.getLog(XslRuntimeUriResolver.class);
    private OXPath10Expression _expr;
    private final URI _baseResourceURI;

    public XslRuntimeUriResolver(OXPath10Expression expr, URI baseResourceURI) {
        this._expr = expr;
        this._baseResourceURI = baseResourceURI;
    }

    public Source resolve(String href, String base) throws TransformerException {
        URI uri;
        try {
            uri = new URI(FileUtils.encodePath((String)href));
        }
        catch (URISyntaxException e) {
            return null;
        }
        OXslSheet sheet = this._expr.xslSheets.get(uri);
        String result = sheet != null ? sheet.sheetBody : this.getResourceAsString(uri);
        if (result != null) {
            return new StreamSource(new StringReader(result));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResourceAsString(URI docUri) {
        block16: {
            String string;
            URI resolvedURI = this._baseResourceURI.resolve(docUri);
            InputStream is = null;
            try {
                File f = new File(resolvedURI);
                if (!f.exists()) {
                    String string2 = null;
                    return string2;
                }
                is = new FileInputStream(f);
                string = new String(StreamUtils.read((InputStream)is));
            }
            catch (IOException e) {
                __log.info((Object)("Couldn't load XSL resource " + docUri));
                break block16;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception ex) {}
            }
            return string;
        }
        return null;
    }
}

