/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2.xpath20;

import java.util.Calendar;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.rtrep.v2.EvaluationContext;
import org.apache.ode.bpel.rtrep.v2.OLink;
import org.apache.ode.bpel.rtrep.v2.OMessageVarType;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.OXsdTypeVarType;
import org.apache.ode.bpel.rtrep.v2.xpath10.OXPath10ExpressionBPEL20;
import org.apache.ode.bpel.rtrep.v2.xpath20.WrappedFaultException;
import org.apache.ode.utils.xsd.XSTypes;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JaxpVariableResolver
implements XPathVariableResolver {
    private static final Log __log = LogFactory.getLog(JaxpVariableResolver.class);
    private EvaluationContext _ectx;
    private OXPath10ExpressionBPEL20 _oxpath;
    private Configuration _config;

    public JaxpVariableResolver(EvaluationContext ectx, OXPath10ExpressionBPEL20 oxpath, Configuration config) {
        this._ectx = ectx;
        this._oxpath = oxpath;
        this._config = config;
    }

    public Object resolveVariable(QName variableName) {
        String partName;
        String varName;
        __log.debug((Object)("Resolving variable " + variableName));
        if (!(this._oxpath instanceof OXPath10ExpressionBPEL20)) {
            throw new IllegalStateException("XPath variables not supported for bpel 1.1");
        }
        if (variableName.getNamespaceURI().equals("http://www.apache.org/ode/type/extension") && "pid".equals(variableName.getLocalPart())) {
            return this._ectx.getProcessId();
        }
        OXPath10ExpressionBPEL20 expr = this._oxpath;
        if (expr.isJoinExpression) {
            OLink olink = (OLink)this._oxpath.links.get(variableName.getLocalPart());
            try {
                return this._ectx.isLinkActive(olink) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (FaultException e) {
                throw new WrappedFaultException(e);
            }
        }
        int dotloc = variableName.getLocalPart().indexOf(46);
        if (dotloc == -1) {
            varName = variableName.getLocalPart();
            partName = null;
        } else {
            varName = variableName.getLocalPart().substring(0, dotloc);
            partName = variableName.getLocalPart().substring(dotloc + 1);
        }
        OScope.Variable variable = (OScope.Variable)this._oxpath.vars.get(varName);
        OMessageVarType.Part part = partName == null ? null : ((OMessageVarType)variable.type).parts.get(partName);
        try {
            Node variableNode = this._ectx.readVariable(variable, part);
            if (variableNode == null) {
                throw new FaultException(variable.getOwner().constants.qnSelectionFailure, "Unknown variable " + variableName.getLocalPart());
            }
            if (this._ectx.narrowTypes()) {
                if (variable.type instanceof OXsdTypeVarType && ((OXsdTypeVarType)variable.type).simple) {
                    return this.getSimpleContent(variableNode, ((OXsdTypeVarType)variable.type).xsdType);
                }
                if (part != null && part.type instanceof OXsdTypeVarType && ((OXsdTypeVarType)part.type).simple) {
                    return this.getSimpleContent(variableNode, ((OXsdTypeVarType)part.type).xsdType);
                }
            }
            return variableNode;
        }
        catch (FaultException e) {
            throw new WrappedFaultException(e);
        }
    }

    private Object getSimpleContent(Node simpleNode, QName type) {
        Document doc = simpleNode instanceof Document ? (Document)simpleNode : simpleNode.getOwnerDocument();
        String text = simpleNode.getTextContent();
        try {
            Object jobj = XSTypes.toJavaObject((QName)type, (String)text);
            if (jobj instanceof Calendar) {
                return ((Calendar)jobj).getTime();
            }
            if (jobj instanceof String) {
                return doc.createTextNode(jobj.toString());
            }
            return jobj;
        }
        catch (Exception e) {
            try {
                return Integer.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                try {
                    return Double.valueOf(text);
                }
                catch (NumberFormatException nfe2) {
                    if (simpleNode.getParentNode() != null) {
                        return simpleNode.getParentNode().getChildNodes();
                    }
                    return doc.createTextNode(text);
                }
            }
        }
    }
}

