/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.SystemUtils;

public class HierarchicalProperties {
    private static final Log log = LogFactory.getLog(HierarchicalProperties.class);
    public static final String ODE_PREFFIX = "ode";
    private Properties props = new Properties();
    private Map<String, String> aliases = new HashMap<String, String>();
    private File file;
    private String prefix;
    private String dotted_prefix;
    private MultiKeyMap hierarchicalMap = new MultiKeyMap();
    private transient MultiKeyMap cacheOfImmutableMaps = new MultiKeyMap();

    public HierarchicalProperties(File file, String prefix) throws IOException {
        this.file = file;
        this.prefix = prefix;
        this.dotted_prefix = "." + prefix + ".";
        this.loadFile();
    }

    public HierarchicalProperties(File file) throws IOException {
        this(file, ODE_PREFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile() throws IOException {
        if (!this.file.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("File does not exist [" + this.file + "] Properties will be empty."));
            }
            return;
        }
        this.clear();
        FileInputStream fis = new FileInputStream(this.file);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading property file: " + this.file));
            }
            this.props.load(fis);
        }
        finally {
            fis.close();
        }
        this.hierarchicalMap.put(null, null, (Object)new ChainedMap());
        for (Map.Entry<Object, Object> e : this.props.entrySet()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            value = SystemUtils.replaceSystemProperties(value);
            this.props.put(key, value);
            if (key.startsWith("alias.")) {
                String alias = key.substring("alias.".length(), key.length());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Alias found: " + alias + " -> " + value));
                }
                this.aliases.put(value, alias);
                continue;
            }
            String[] info = this.parseProperty(key);
            String nsalias = info[0];
            String service = info[1];
            String port = info[2];
            String targetedProperty = info[3];
            QName qname = nsalias != null ? new QName(nsalias, service) : null;
            ChainedMap p = (ChainedMap)this.hierarchicalMap.get((Object)qname, (Object)port);
            if (p == null) {
                ChainedMap s = (ChainedMap)this.hierarchicalMap.get((Object)qname, null);
                if (s == null) {
                    s = new ChainedMap(this.getRootMap());
                    this.hierarchicalMap.put((Object)qname, null, (Object)s);
                }
                p = new ChainedMap(s);
                this.hierarchicalMap.put((Object)qname, (Object)port, (Object)p);
            }
            p.put(targetedProperty, value);
        }
    }

    public void clear() {
        this.props.clear();
        this.aliases.clear();
        this.hierarchicalMap.clear();
        this.cacheOfImmutableMaps.clear();
    }

    protected ChainedMap getRootMap() {
        Object o = this.hierarchicalMap.get(null, null);
        if (o == null) {
            o = new ChainedMap();
            this.hierarchicalMap.put(null, null, o);
        }
        return (ChainedMap)o;
    }

    public Map getProperties(String serviceNamespaceURI, String serviceLocalPart) {
        return this.getProperties(new QName(serviceNamespaceURI, serviceLocalPart));
    }

    public Map getProperties(QName service) {
        return this.getProperties(service, null);
    }

    public Map getProperties(String serviceNamespaceURI, String serviceLocalPart, String port) {
        return this.getProperties(new QName(serviceNamespaceURI, serviceLocalPart), port);
    }

    public Map getProperties(QName service, String port) {
        if (this.hierarchicalMap.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        Map cachedMap = (Map)this.cacheOfImmutableMaps.get((Object)(service = this.resolveAlias(service)), (Object)port);
        if (cachedMap != null) {
            return cachedMap;
        }
        ChainedMap cm = (ChainedMap)this.hierarchicalMap.get((Object)service, (Object)port);
        if (cm == null && (cm = (ChainedMap)this.hierarchicalMap.get((Object)service, null)) == null) {
            return this.getProperties((QName)null, null);
        }
        Map snapshotMap = new HashMap(cm.size() * 15 / 10);
        for (Object key : cm.keySet()) {
            snapshotMap.put(key, cm.get(key));
        }
        snapshotMap = Collections.unmodifiableMap(snapshotMap);
        this.cacheOfImmutableMaps.put((Object)service, (Object)port, snapshotMap);
        return snapshotMap;
    }

    public String getProperty(String property) {
        return (String)this.getRootMap().get(property);
    }

    public String getProperty(String serviceNamespaceURI, String serviceLocalPart, String property) {
        return this.getProperty(new QName(serviceNamespaceURI, serviceLocalPart), property);
    }

    public String getProperty(QName service, String property) {
        return this.getProperty(service, null, property);
    }

    public String getProperty(String serviceNamespaceURI, String serviceLocalPart, String port, String property) {
        return this.getProperty(new QName(serviceNamespaceURI, serviceLocalPart), port, property);
    }

    public String getProperty(QName service, String port, String property) {
        ChainedMap cm = (ChainedMap)this.hierarchicalMap.get((Object)this.resolveAlias(service), (Object)port);
        if (cm == null) {
            cm = this.getRootMap();
        }
        return (String)cm.get(property);
    }

    public String getPrefix() {
        return this.prefix;
    }

    private QName resolveAlias(QName service) {
        if (service != null && this.aliases.containsKey(service.getNamespaceURI())) {
            return new QName(this.aliases.get(service.getNamespaceURI()), service.getLocalPart());
        }
        return service;
    }

    private String[] parseProperty(String property) {
        String[] res = new String[4];
        int index = property.indexOf(this.dotted_prefix);
        if (index <= 0) {
            res[3] = property;
        } else {
            res[3] = property.substring(index + this.dotted_prefix.length());
            String prefix = property.substring(0, index);
            String[] t = prefix.split("\\.");
            if (t.length != 2 && t.length != 3) {
                throw new IllegalArgumentException("Invalid property name:" + property + " Expected pattern: [nsalias.service.[port.]" + prefix + ".]property");
            }
            if (t.length >= 2) {
                res[0] = t[0];
                res[1] = t[1];
            }
            if (t.length > 2) {
                res[2] = t[2];
            }
        }
        return res;
    }

    private static class ChainedMap {
        private ChainedMap parent;
        private Map child;

        public ChainedMap() {
            this.parent = null;
            this.child = new HashMap();
        }

        public ChainedMap(ChainedMap parent) {
            this.parent = parent;
            this.child = new HashMap();
        }

        public ChainedMap getParent() {
            return this.parent;
        }

        public void setParent(ChainedMap parent) {
            this.parent = parent;
        }

        public Object getLocally(Object key) {
            return this.child.get(key);
        }

        public void clearLocally() {
            this.child.clear();
        }

        public Object get(Object key) {
            Object lv = this.getLocally(key);
            if (lv != null) {
                return lv;
            }
            if (this.parent != null) {
                return this.parent.get(key);
            }
            return null;
        }

        public Object put(Object key, Object value) {
            if (key == null) {
                throw new NullPointerException("Null keys forbidden!");
            }
            return this.child.put(key, value);
        }

        public void putAll(Map t) {
            for (Map.Entry e : t.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return this.child.isEmpty() && (this.parent == null || this.parent.isEmpty());
        }

        public boolean containsKey(Object key) {
            if (key == null) {
                throw new NullPointerException("Null keys forbidden!");
            }
            return this.child.containsKey(key) || this.parent != null && this.parent.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.child.containsValue(value) || this.parent != null && this.parent.containsValue(value);
        }

        public int size() {
            return this.keySet().size();
        }

        public Set keySet() {
            HashSet s = new HashSet(this.child.keySet());
            if (this.parent != null) {
                s.addAll(this.parent.keySet());
            }
            return s;
        }
    }
}

