/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.ode.utils.LoggingStatementWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingConnectionWrapper
implements Connection {
    private Connection _conn;
    private Log _log;

    public LoggingConnectionWrapper(Connection conn) {
        this._conn = conn;
    }

    public LoggingConnectionWrapper(Connection conn, Log log) {
        this._conn = conn;
        this._log = log;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._conn.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        if (this.shouldPrint()) {
            this.print("close");
        }
        this._conn.close();
    }

    @Override
    public void commit() throws SQLException {
        if (this.shouldPrint()) {
            this.print("commit");
        }
        this._conn.commit();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this._conn.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this._conn.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this._conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this._conn.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this._conn.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this._conn.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this._conn.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this._conn.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this._conn.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._conn.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._conn.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this._conn.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this._conn.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.shouldPrint()) {
            this.print("prepareCall: " + sql);
        }
        return new LoggingStatementWrapper(this._conn.prepareCall(sql), this._log);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.shouldPrint()) {
            this.print("prepareCall: " + sql);
        }
        return new LoggingStatementWrapper(this._conn.prepareCall(sql, resultSetType, resultSetConcurrency), this._log);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.shouldPrint()) {
            this.print("prepareCall: " + sql);
        }
        return new LoggingStatementWrapper(this._conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this._log);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.shouldPrint()) {
            this.print("prepareStmt: " + sql);
        }
        if (sql.indexOf("ODE_SCOPE") > 0) {
            for (StackTraceElement traceElement : Thread.currentThread().getStackTrace()) {
                this.print(traceElement.toString());
            }
        }
        return new LoggingStatementWrapper(this._conn.prepareStatement(sql), this._log);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.shouldPrint()) {
            this.print("prepareStmt: " + sql);
        }
        return new LoggingStatementWrapper(this._conn.prepareStatement(sql, autoGeneratedKeys), this._log);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (this.shouldPrint()) {
            this.print("prepareStmt: " + sql);
        }
        return new LoggingStatementWrapper(this._conn.prepareStatement(sql, columnIndexes), this._log);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (this.shouldPrint()) {
            this.print("prepareStmt: " + sql);
        }
        return new LoggingStatementWrapper(this._conn.prepareStatement(sql, columnNames), this._log);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.shouldPrint()) {
            this.print("prepareStmt: " + sql);
        }
        return new LoggingStatementWrapper(this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency), this._log);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.shouldPrint()) {
            this.print("prepareStmt: " + sql);
        }
        return new LoggingStatementWrapper(this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this._log);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this._conn.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        if (this.shouldPrint()) {
            this.print("rollback");
        }
        this._conn.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.shouldPrint()) {
            this.print("rollback");
        }
        this._conn.rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this._conn.setAutoCommit(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this._conn.setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this._conn.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this._conn.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this._conn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this._conn.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (this.shouldPrint()) {
            this.print("Setting isolation level to " + level);
        }
        this._conn.setTransactionIsolation(level);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this._conn.setTypeMap(map);
    }

    private boolean shouldPrint() {
        if (this._log != null) {
            return this._log.isDebugEnabled();
        }
        return true;
    }

    private void print(String str) {
        if (this._log != null) {
            this._log.debug((Object)str);
        } else {
            System.out.println(str);
        }
    }
}

