/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.ode.utils.LoggingConnectionWrapper;

public class LoggingDataSourceWrapper
implements DataSource {
    private DataSource _wrapped;
    private Log _log;

    public LoggingDataSourceWrapper(DataSource wrapped, Log log) {
        this._wrapped = wrapped;
        this._log = log;
    }

    public Connection getConnection() throws SQLException {
        LoggingConnectionWrapper conn = new LoggingConnectionWrapper(this._wrapped.getConnection(), this._log);
        if (this.shouldPrint()) {
            this.print("getConnection (tx=" + conn.getTransactionIsolation() + ")");
        }
        return conn;
    }

    public Connection getConnection(String username, String password) throws SQLException {
        LoggingConnectionWrapper conn = new LoggingConnectionWrapper(this._wrapped.getConnection(username, password), this._log);
        if (this.shouldPrint()) {
            this.print("getConnection (tx=" + conn.getTransactionIsolation() + ")");
        }
        return conn;
    }

    public int getLoginTimeout() throws SQLException {
        return this._wrapped.getLoginTimeout();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this._wrapped.getLogWriter();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this._wrapped.setLoginTimeout(seconds);
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this._wrapped.setLogWriter(out);
    }

    private boolean shouldPrint() {
        if (this._log != null) {
            return this._log.isDebugEnabled();
        }
        return true;
    }

    private void print(String str) {
        if (this._log != null) {
            this._log.debug((Object)str);
        } else {
            System.out.println(str);
        }
    }
}

