/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchDog<T>
implements Runnable {
    public static final long DEFAULT_DELAY = 30000L;
    final Log log = LogFactory.getLog(this.getClass());
    private long expire;
    private T lastModif;
    private long delay;
    private boolean existedBefore;
    private boolean warnedAlready;
    private boolean interrupted;
    protected final Mutable<T> mutable;

    public WatchDog(Mutable<T> mutable, long delay) {
        this(mutable);
        this.delay = delay;
    }

    public WatchDog(Mutable<T> mutable) {
        this.mutable = mutable;
        this.delay = 30000L;
    }

    protected boolean isInitialized() {
        return true;
    }

    protected void init() {
    }

    protected void doOnDelete() {
        this.init();
    }

    protected void doOnUpdate() {
        this.init();
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    @Override
    public void run() {
        try {
            while (!this.interrupted) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.check();
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Exception occured. Thread will stop", (Throwable)e);
        }
    }

    public final void check() {
        long now = System.currentTimeMillis();
        if (this.expire <= now) {
            this.expire = now + this.delay;
            if (this.mutable.exists()) {
                this.existedBefore = true;
                if (this.lastModif == null || this.mutable.hasChangedSince(this.lastModif)) {
                    this.lastModif = this.mutable.lastModified();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)(this.mutable + " has been modified"));
                    }
                    this.doOnUpdate();
                    this.warnedAlready = false;
                }
            } else if (!this.isInitialized()) {
                this.init();
            } else {
                if (this.existedBefore) {
                    this.existedBefore = false;
                    this.lastModif = null;
                    this.doOnDelete();
                }
                if (!this.warnedAlready) {
                    this.warnedAlready = true;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)(this.mutable + "] does not exist."));
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Mutable<T> {
        public boolean exists();

        public boolean hasChangedSince(T var1);

        public T lastModified();
    }
}

