/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.fs;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    private static final Log __log = LogFactory.getLog(FileUtils.class);

    public static boolean deepDelete(File file) {
        if (file.exists()) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("deleting: " + file.getAbsolutePath()));
            }
            if (file.delete()) {
                return true;
            }
            if (file.isDirectory()) {
                boolean success = true;
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    success &= FileUtils.deepDelete(files[i]);
                }
                return success ? file.delete() : false;
            }
            __log.error((Object)("Unable to deepDelete file " + file.getAbsolutePath() + "; this may be caused by a descriptor leak and should be reported."));
            return false;
        }
        return true;
    }

    public static List<File> directoryEntriesInPath(File rootDirectory) {
        return FileUtils.directoryEntriesInPath(rootDirectory, null);
    }

    public static List<File> directoryEntriesInPath(File rootDirectory, FileFilter filter) {
        if (rootDirectory == null) {
            throw new IllegalArgumentException("File must not be null!");
        }
        if (!rootDirectory.exists()) {
            throw new IllegalArgumentException("File does not exist!");
        }
        ArrayList<File> collectedFiles = new ArrayList<File>(32);
        if (rootDirectory.isFile()) {
            if (filter == null || filter != null && filter.accept(rootDirectory)) {
                collectedFiles.add(rootDirectory);
            }
            return collectedFiles;
        }
        FileUtils.directoryEntriesInPath(collectedFiles, rootDirectory, filter);
        return collectedFiles;
    }

    private static void directoryEntriesInPath(List<File> collectedFiles, File parentDir, FileFilter filter) {
        File[] files;
        if (filter == null || filter != null && filter.accept(parentDir)) {
            collectedFiles.add(parentDir);
        }
        if ((files = parentDir.listFiles()) != null) {
            for (File currentFile : files) {
                if (filter == null || filter != null && filter.accept(currentFile)) {
                    collectedFiles.add(currentFile);
                }
                if (!currentFile.isDirectory()) continue;
                FileUtils.directoryEntriesInPath(collectedFiles, currentFile, filter);
            }
        }
    }

    public static String encodePath(String path) {
        return path.replaceAll(" ", "%20");
    }
}

