/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.wsdl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.wsdl.extensions.http.HTTPUrlEncoded;
import javax.wsdl.extensions.http.HTTPUrlReplacement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.wsdl.Messages;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlUtils {
    private static final Messages msgs = Messages.getMessages(Messages.class);

    public static boolean useSOAPBinding(Binding binding) {
        ExtensibilityElement element = WsdlUtils.getBindingExtension(binding);
        return SOAPBinding.class.isAssignableFrom(element.getClass());
    }

    public static boolean useHTTPBinding(Binding binding) {
        ExtensibilityElement element = WsdlUtils.getBindingExtension(binding);
        if (element == null) {
            BindingOperation anOperation = (BindingOperation)binding.getBindingOperations().get(0);
            ExtensibilityElement opExt = WsdlUtils.getOperationExtension(anOperation);
            return HTTPOperation.class.isAssignableFrom(opExt.getClass());
        }
        return HTTPBinding.class.isAssignableFrom(element.getClass());
    }

    public static boolean useSOAPBinding(Port port) {
        return WsdlUtils.useSOAPBinding(port.getBinding());
    }

    public static boolean useHTTPBinding(Port port) {
        return WsdlUtils.useHTTPBinding(port.getBinding());
    }

    public static boolean useSOAPBinding(Definition def, QName serviceName, String portName) {
        Service serviceDef = def.getService(serviceName);
        if (serviceDef == null) {
            throw new IllegalArgumentException(msgs.msgServiceDefinitionNotFound(serviceName));
        }
        Port port = serviceDef.getPort(portName);
        if (port == null) {
            throw new IllegalArgumentException(msgs.msgPortDefinitionNotFound(serviceName, portName));
        }
        return WsdlUtils.useSOAPBinding(port);
    }

    public static boolean useHTTPBinding(Definition def, QName serviceName, String portName) {
        Service serviceDef = def.getService(serviceName);
        if (serviceDef == null) {
            throw new IllegalArgumentException(msgs.msgServiceDefinitionNotFound(serviceName));
        }
        Port port = serviceDef.getPort(portName);
        if (port == null) {
            throw new IllegalArgumentException(msgs.msgPortDefinitionNotFound(serviceName, portName));
        }
        return WsdlUtils.useHTTPBinding(port);
    }

    public static ExtensibilityElement getBindingExtension(Binding binding) {
        ArrayList bindings = new ArrayList();
        CollectionsX.filter(bindings, binding.getExtensibilityElements(), HTTPBinding.class);
        CollectionsX.filter(bindings, binding.getExtensibilityElements(), SOAPBinding.class);
        if (bindings.size() == 0) {
            return null;
        }
        if (bindings.size() > 1) {
            throw new IllegalArgumentException(msgs.msgMultipleBindings(binding.getQName()));
        }
        ExtensibilityElement result = (ExtensibilityElement)bindings.iterator().next();
        return result;
    }

    public static ExtensibilityElement getBindingExtension(Port port) {
        Binding binding = port.getBinding();
        if (binding == null) {
            throw new IllegalArgumentException(msgs.msgBindingNotFound(port.getName()));
        }
        return WsdlUtils.getBindingExtension(binding);
    }

    public static ExtensibilityElement getOperationExtension(BindingOperation bindingOperation) {
        ArrayList operations = new ArrayList();
        CollectionsX.filter(operations, bindingOperation.getExtensibilityElements(), HTTPOperation.class);
        CollectionsX.filter(operations, bindingOperation.getExtensibilityElements(), SOAPOperation.class);
        if (operations.size() == 0) {
            throw new IllegalArgumentException(msgs.msgNoBindingForOperation(bindingOperation.getName()));
        }
        if (operations.size() > 1) {
            throw new IllegalArgumentException(msgs.msgMultipleBindingsForOperation(bindingOperation.getName()));
        }
        ExtensibilityElement result = (ExtensibilityElement)operations.iterator().next();
        return result;
    }

    public static boolean useUrlEncoded(BindingInput bindingInput) {
        Collection<HTTPUrlEncoded> coll = CollectionsX.filter(bindingInput.getExtensibilityElements(), HTTPUrlEncoded.class);
        return !coll.isEmpty();
    }

    public static boolean useUrlReplacement(BindingInput bindingInput) {
        Collection<HTTPUrlReplacement> coll = CollectionsX.filter(bindingInput.getExtensibilityElements(), HTTPUrlReplacement.class);
        return !coll.isEmpty();
    }

    public static boolean useMimeMultipartRelated(BindingInput bindingInput) {
        Collection<MIMEMultipartRelated> coll = CollectionsX.filter(bindingInput.getExtensibilityElements(), MIMEMultipartRelated.class);
        return !coll.isEmpty();
    }

    public static MIMEContent getMimeContent(List extensibilityElements) {
        Collection<MIMEContent> coll = CollectionsX.filter(extensibilityElements, MIMEContent.class);
        if (coll.size() == 0) {
            return null;
        }
        if (coll.size() > 1) {
            throw new IllegalArgumentException(msgs.msgMultipleMimeContent());
        }
        return coll.iterator().next();
    }

    public static ExtensibilityElement getAddressExtension(Port port) {
        ArrayList operations = new ArrayList();
        CollectionsX.filter(operations, port.getExtensibilityElements(), HTTPAddress.class);
        CollectionsX.filter(operations, port.getExtensibilityElements(), SOAPAddress.class);
        if (operations.size() == 0) {
            throw new IllegalArgumentException(msgs.msgNoAddressForPort(port.getName()));
        }
        if (operations.size() > 1) {
            throw new IllegalArgumentException(msgs.msgMultipleAddressesForPort(port.getName()));
        }
        ExtensibilityElement result = (ExtensibilityElement)operations.iterator().next();
        return result;
    }

    public static String getOperationVerb(BindingOperation bindingOperation) {
        Collection<UnknownExtensibilityElement> unknownExtElements = CollectionsX.filter(bindingOperation.getExtensibilityElements(), UnknownExtensibilityElement.class);
        for (UnknownExtensibilityElement extensibilityElement : unknownExtElements) {
            Element e = extensibilityElement.getElement();
            if (!"http://www.apache.org/ode/type/extension/http".equalsIgnoreCase(e.getNamespaceURI()) || !"binding".equals(extensibilityElement.getElement().getLocalName()) || !e.hasAttribute("verb")) continue;
            return e.getAttribute("verb");
        }
        return null;
    }

    public static boolean isOdeFault(BindingFault fault) {
        Collection<UnknownExtensibilityElement> unknownExtElements = CollectionsX.filter(fault.getExtensibilityElements(), UnknownExtensibilityElement.class);
        for (UnknownExtensibilityElement extensibilityElement : unknownExtElements) {
            Element e = extensibilityElement.getElement();
            if (!"http://www.apache.org/ode/type/extension/http".equalsIgnoreCase(e.getNamespaceURI()) || !"fault".equals(extensibilityElement.getElement().getLocalName())) continue;
            if (e.hasAttribute("name")) {
                return fault.getName().equals(e.getAttribute("name"));
            }
            return true;
        }
        return false;
    }

    public static Collection<UnknownExtensibilityElement> getHttpHeaders(List extensibilityElements) {
        Collection<UnknownExtensibilityElement> unknownExtElements = CollectionsX.filter(extensibilityElements, UnknownExtensibilityElement.class);
        for (UnknownExtensibilityElement extensibilityElement : unknownExtElements) {
            Element e = extensibilityElement.getElement();
            if ("http://www.apache.org/ode/type/extension/http".equalsIgnoreCase(e.getNamespaceURI()) && "header".equals(extensibilityElement.getElement().getLocalName())) continue;
            unknownExtElements.remove(extensibilityElement);
        }
        return unknownExtElements;
    }

    public static Fault inferFault(Operation operation, QName elName) {
        for (Fault f : operation.getFaults().values()) {
            Part p;
            Collection parts;
            if (f.getMessage() == null || (parts = f.getMessage().getParts().values()).isEmpty() || (p = (Part)parts.iterator().next()).getElementName() == null || !p.getElementName().equals(elName)) continue;
            return f;
        }
        return null;
    }

    public static String resolveVerb(Binding binding, BindingOperation bindingOperation) {
        HTTPBinding httpBinding = (HTTPBinding)WsdlUtils.getBindingExtension(binding);
        String portVerb = httpBinding != null ? httpBinding.getVerb() : null;
        String operationVerb = WsdlUtils.getOperationVerb(bindingOperation);
        return operationVerb != null ? operationVerb : portVerb;
    }
}

