/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.xsl;

import java.io.StringReader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.ode.utils.xsl.XslTransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XslTransformHandler {
    private static XslTransformHandler __singleton;
    private TransformerFactory _transformerFactory = null;
    private final HashMap<URI, Templates> _templateCache = new HashMap();

    public static synchronized XslTransformHandler getInstance() {
        if (__singleton == null) {
            __singleton = new XslTransformHandler();
        }
        return __singleton;
    }

    private XslTransformHandler() {
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this._transformerFactory = transformerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseXSLSheet(URI uri, String body, URIResolver resolver) {
        Templates tm;
        try {
            this._transformerFactory.setURIResolver(resolver);
            tm = this._transformerFactory.newTemplates(new StreamSource(new StringReader(body)));
        }
        catch (TransformerConfigurationException e) {
            throw new XslTransformException(e);
        }
        HashMap<URI, Templates> hashMap = this._templateCache;
        synchronized (hashMap) {
            this._templateCache.put(uri, tm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheXSLSheet(URI uri, String body, URIResolver resolver) {
        Templates tm;
        HashMap<URI, Templates> hashMap = this._templateCache;
        synchronized (hashMap) {
            tm = this._templateCache.get(uri);
        }
        if (tm == null) {
            this.parseXSLSheet(uri, body, resolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(URI uri, Source source, Result result, Map<QName, Object> parameters, URIResolver resolver) {
        Templates tm;
        HashMap<URI, Templates> hashMap = this._templateCache;
        synchronized (hashMap) {
            tm = this._templateCache.get(uri);
        }
        if (tm == null) {
            throw new XslTransformException("XSL sheet" + uri + " has not been parsed before transformation!");
        }
        try {
            Transformer tf = tm.newTransformer();
            tf.setURIResolver(resolver);
            if (parameters != null) {
                for (Map.Entry<QName, Object> param : parameters.entrySet()) {
                    tf.setParameter(param.getKey().getLocalPart(), param.getValue());
                }
            }
            tf.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new XslTransformException(e);
        }
        catch (TransformerException e) {
            throw new XslTransformException("XSL Transformation failed!", e);
        }
    }

    public void setErrorListener(ErrorListener l) {
        this._transformerFactory.setErrorListener(l);
    }
}

