/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.api.domain;

import org.apache.olingo.commons.api.format.ContentType;

public enum ClientLinkType {
    ENTITY_NAVIGATION(ContentType.APPLICATION_ATOM_XML_ENTRY),
    ENTITY_SET_NAVIGATION(ContentType.APPLICATION_ATOM_XML_FEED),
    ASSOCIATION(ContentType.APPLICATION_XML),
    MEDIA_EDIT("*/*"),
    ENTITY_BINDING(ContentType.APPLICATION_XML),
    ENTITY_COLLECTION_BINDING(ContentType.APPLICATION_XML);

    private String type;

    private ClientLinkType(String type) {
        this.type = type;
    }

    private ClientLinkType(ContentType contentType) {
        this(contentType.toContentTypeString());
    }

    private ClientLinkType setType(String type) {
        this.type = type;
        return this;
    }

    public static ClientLinkType fromString(String rel, String type) {
        if (rel != null && rel.startsWith("http://docs.oasis-open.org/odata/ns/edit-media/")) {
            return MEDIA_EDIT.setType(type == null || type.isEmpty() ? "*/*" : type);
        }
        if (ClientLinkType.ENTITY_NAVIGATION.type.equals(type)) {
            return ENTITY_NAVIGATION;
        }
        if (ClientLinkType.ENTITY_SET_NAVIGATION.type.equals(type)) {
            return ENTITY_SET_NAVIGATION;
        }
        if (ClientLinkType.ASSOCIATION.type.equals(type)) {
            return ASSOCIATION;
        }
        throw new IllegalArgumentException("Invalid link type: " + type);
    }

    public String toString() {
        return this.type;
    }
}

