/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;

public class TransactionItems {
    private final List<EntityInvocationHandler> keys = new ArrayList<EntityInvocationHandler>();
    private final List<Integer> values = new ArrayList<Integer>();

    public EntityInvocationHandler get(Integer value) {
        if (value != null && this.values.contains(value)) {
            return this.keys.get(this.values.indexOf(value));
        }
        return null;
    }

    public Integer get(EntityInvocationHandler key) {
        if (key != null && this.keys.contains(key)) {
            return this.values.get(this.keys.indexOf(key));
        }
        return null;
    }

    public void remove(EntityInvocationHandler key) {
        if (this.keys.contains(key)) {
            this.values.remove(this.keys.indexOf(key));
            this.keys.remove(key);
        }
    }

    public void normalize() {
        HashSet<Integer> toBeRemoved = new HashSet<Integer>();
        for (EntityInvocationHandler key : this.keys) {
            int i = this.keys.indexOf(key);
            if (this.values.get(i) != null) continue;
            toBeRemoved.add(i);
        }
        Iterator<EntityInvocationHandler> i$ = toBeRemoved.iterator();
        while (i$.hasNext()) {
            int i = (Integer)((Object)i$.next());
            this.keys.remove(i);
            this.values.remove(i);
        }
    }

    public void put(EntityInvocationHandler key, Integer value) {
        if (key != null && this.keys.contains(key) && this.values.get(this.keys.indexOf(key)) == null) {
            this.remove(key);
        }
        this.keys.add(key);
        this.values.add(value);
    }

    public List<Integer> sortedValues() {
        ArrayList<Integer> sortedValues = new ArrayList<Integer>(this.values);
        Collections.sort(sortedValues);
        return sortedValues;
    }

    public boolean contains(EntityInvocationHandler key) {
        return this.keys.contains(key);
    }

    public int size() {
        return this.keys.size();
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }
}

