/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientEntitySet;
import org.apache.olingo.client.api.domain.ClientValue;
import org.apache.olingo.client.api.uri.URIBuilder;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.commons.ComplexInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntitySetInvocationHandler;
import org.apache.olingo.ext.proxy.utils.CoreUtils;

public class ProxyUtils {
    public static Object getEntityCollectionProxy(AbstractService<?> service, Class<?> typeRef, Class<?> typeCollectionRef, URI targetEntitySetURI, ClientEntitySet entitySet, URI uri, boolean checkInTheContext) {
        ArrayList<Object> items = new ArrayList<Object>();
        if (entitySet != null) {
            for (ClientEntity entityFromSet : entitySet.getEntities()) {
                items.add(ProxyUtils.getEntityProxy(service, entityFromSet, uri, typeRef, null, checkInTheContext));
            }
        }
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{typeCollectionRef}, new EntityCollectionInvocationHandler(service, items, typeCollectionRef, targetEntitySetURI, uri == null ? null : service.getClient().newURIBuilder(uri.toASCIIString())));
    }

    public static Object getEntitySetProxy(AbstractService<?> service, Class<?> typeRef, URI uri) {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{typeRef}, (InvocationHandler)EntitySetInvocationHandler.getInstance(typeRef, service, uri));
    }

    public static Object getEntityProxy(AbstractService<?> service, ClientEntity entity, URI entitySetURI, Class<?> type, String eTag, boolean checkInTheContext) {
        EntityInvocationHandler handler = EntityInvocationHandler.getInstance(entity, entitySetURI, type, service);
        if (StringUtils.isNotBlank((CharSequence)eTag)) {
            handler.setETag(eTag);
        }
        if (checkInTheContext && service.getContext().entityContext().isAttached(handler)) {
            handler = service.getContext().entityContext().getEntity(handler.getUUID());
            handler.setEntity(entity);
        }
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{type}, (InvocationHandler)handler);
    }

    public static Object getComplexProxy(AbstractService<?> service, String name, ClientValue value, Class<?> ref, EntityInvocationHandler handler, URI baseURI, boolean collectionItem) {
        ComplexInvocationHandler complexHandler;
        URIBuilder targetURI = collectionItem ? null : (baseURI == null ? null : service.getClient().newURIBuilder(baseURI.toASCIIString()).appendPropertySegment(name));
        Class<?> actualRef = ref;
        if (value == null) {
            complexHandler = ComplexInvocationHandler.getInstance(actualRef, service, targetURI);
        } else {
            actualRef = CoreUtils.getComplexTypeRef(service, value);
            complexHandler = ComplexInvocationHandler.getInstance(value.asComplex(), actualRef, service, targetURI);
        }
        complexHandler.setEntityHandler(handler);
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{actualRef}, (InvocationHandler)complexHandler);
    }
}

