/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.api.edmx;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.server.api.edmx.EdmxReferenceInclude;
import org.apache.olingo.server.api.edmx.EdmxReferenceIncludeAnnotation;

public class EdmxReference {
    private final URI uri;
    private final List<EdmxReferenceInclude> edmxIncludes;
    private final List<EdmxReferenceIncludeAnnotation> edmxIncludeAnnotations;

    public EdmxReference(URI uri) {
        this.uri = uri;
        this.edmxIncludes = new ArrayList<EdmxReferenceInclude>();
        this.edmxIncludeAnnotations = new ArrayList<EdmxReferenceIncludeAnnotation>();
    }

    public URI getUri() {
        return this.uri;
    }

    public List<EdmxReferenceInclude> getIncludes() {
        return Collections.unmodifiableList(this.edmxIncludes);
    }

    public EdmxReference addInclude(EdmxReferenceInclude include) {
        this.edmxIncludes.add(include);
        return this;
    }

    public List<EdmxReferenceIncludeAnnotation> getIncludeAnnotations() {
        return Collections.unmodifiableList(this.edmxIncludeAnnotations);
    }

    public EdmxReference addIncludeAnnotation(EdmxReferenceIncludeAnnotation includeAnnotation) {
        this.edmxIncludeAnnotations.add(includeAnnotation);
        return this;
    }
}

