/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.api.processor;

import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.etag.ETagHelper;
import org.apache.olingo.server.api.etag.ServiceMetadataETagSupport;
import org.apache.olingo.server.api.processor.ErrorProcessor;
import org.apache.olingo.server.api.processor.MetadataProcessor;
import org.apache.olingo.server.api.processor.ServiceDocumentProcessor;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.uri.UriInfo;

public class DefaultProcessor
implements MetadataProcessor,
ServiceDocumentProcessor,
ErrorProcessor {
    private OData odata;
    private ServiceMetadata serviceMetadata;

    @Override
    public void init(OData odata, ServiceMetadata serviceMetadata) {
        this.odata = odata;
        this.serviceMetadata = serviceMetadata;
    }

    @Override
    public void readServiceDocument(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestedContentType) throws ODataApplicationException, ODataLibraryException {
        boolean isNotModified = false;
        ServiceMetadataETagSupport eTagSupport = this.serviceMetadata.getServiceMetadataETagSupport();
        if (eTagSupport != null && eTagSupport.getServiceDocumentETag() != null) {
            response.setHeader("ETag", eTagSupport.getServiceDocumentETag());
            ETagHelper eTagHelper = this.odata.createETagHelper();
            isNotModified = eTagHelper.checkReadPreconditions(eTagSupport.getServiceDocumentETag(), request.getHeaders("If-Match"), request.getHeaders("If-None-Match"));
        }
        if (isNotModified) {
            response.setStatusCode(HttpStatusCode.NOT_MODIFIED.getStatusCode());
        } else {
            ODataSerializer serializer = this.odata.createSerializer(requestedContentType);
            response.setContent(serializer.serviceDocument(this.serviceMetadata, null).getContent());
            response.setStatusCode(HttpStatusCode.OK.getStatusCode());
            response.setHeader("Content-Type", requestedContentType.toContentTypeString());
        }
    }

    @Override
    public void readMetadata(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestedContentType) throws ODataApplicationException, ODataLibraryException {
        boolean isNotModified = false;
        ServiceMetadataETagSupport eTagSupport = this.serviceMetadata.getServiceMetadataETagSupport();
        if (eTagSupport != null && eTagSupport.getMetadataETag() != null) {
            response.setHeader("ETag", eTagSupport.getMetadataETag());
            ETagHelper eTagHelper = this.odata.createETagHelper();
            isNotModified = eTagHelper.checkReadPreconditions(eTagSupport.getMetadataETag(), request.getHeaders("If-Match"), request.getHeaders("If-None-Match"));
        }
        if (isNotModified) {
            response.setStatusCode(HttpStatusCode.NOT_MODIFIED.getStatusCode());
        } else {
            ODataSerializer serializer = this.odata.createSerializer(requestedContentType);
            response.setContent(serializer.metadataDocument(this.serviceMetadata).getContent());
            response.setStatusCode(HttpStatusCode.OK.getStatusCode());
            response.setHeader("Content-Type", requestedContentType.toContentTypeString());
        }
    }

    @Override
    public void processError(ODataRequest request, ODataResponse response, ODataServerError serverError, ContentType requestedContentType) {
        try {
            ODataSerializer serializer = this.odata.createSerializer(requestedContentType);
            response.setContent(serializer.error(serverError).getContent());
            response.setStatusCode(serverError.getStatusCode());
            response.setHeader("Content-Type", requestedContentType.toContentTypeString());
        }
        catch (Exception e) {
            String responseContent = "{\"error\":{\"code\":null,\"message\":\"An unexpected exception occurred during error processing\"}}";
            response.setContent(new ByteArrayInputStream(responseContent.getBytes(Charset.forName("utf-8"))));
            response.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            response.setHeader("Content-Type", ContentType.APPLICATION_JSON.toContentTypeString());
        }
    }
}

