/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.apache.oodt.commons.ConfigurationEntityResolver;
import org.apache.oodt.commons.ExecServerConfig;
import org.apache.oodt.commons.util.DOMParser;
import org.apache.oodt.commons.util.XML;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Configuration {
    public static final int INT = 7577;
    public static final int INT1 = 6000000;
    static Configuration configuration = null;
    public static final String ENTITY_DIRS_PROP = "entity.dirs";
    public static final String DEFAULT_CONFIG_FILE = ".edarc.xml";
    public static final String ALT_CONFIG_FILE = ".oodtrc.xml";
    public static final File LIB_CONFIG_FILE = new File(System.getProperty("java.home", "/") + File.separator + "lib" + File.separator + "edarc.xml");
    public static final File ALT_LIB_CONFIG_FILE = new File(System.getProperty("java.home", "/") + File.separator + ".." + File.separator + "lib" + File.separator + "edarc.xml");
    public static final String DTD_FPI = "-//JPL//DTD EDA Configuration 1.0//EN";
    public static final String DTD_OLD_FPI = "-//JPL//DTD OODT Configuration 1.0//EN";
    public static final String DTD_URL = "http://oodt.jpl.nasa.gov/edm-commons/Configuration.dtd";
    public static final String WEB_PROTOCOL_PROPERTY = "org.apache.oodt.commons.Configuration.webProtocol";
    private Properties properties = new Properties();
    Hashtable contextEnvironment = new Hashtable();
    private List execServers = new ArrayList();
    private String webHost;
    private String webPort;
    private File webServerDocumentDirectory;
    private boolean nameServerUsingRIRProtocol;
    private String nameServerVersion;
    private String nameServerHost;
    private String nameServerPort;
    private String nameServerObjectKey;
    private int nameServerStateFrequency;
    private int serverMgrPort;

    public static Configuration getConfiguration() throws IOException, SAXException {
        URL url;
        if (configuration != null) {
            return configuration;
        }
        String urlString = System.getProperty("org.apache.oodt.commons.Configuration.url");
        if (urlString != null) {
            url = new URL(urlString);
        } else {
            File file = null;
            String filename = System.getProperty("org.apache.oodt.commons.Configuration.file");
            if (filename != null) {
                file = new File(filename);
                if (!file.exists()) {
                    throw new IOException("File " + file + " not found");
                }
            } else {
                ArrayList<File> candidates = new ArrayList<File>();
                File homedir = new File(System.getProperty("user.home", "/"));
                File homedirfile = new File(homedir, DEFAULT_CONFIG_FILE);
                candidates.add(homedirfile);
                File alt = new File(homedir, ALT_CONFIG_FILE);
                candidates.add(alt);
                String edaHome = System.getProperty("eda.home");
                if (edaHome != null) {
                    File edaHomeDir = new File(edaHome);
                    candidates.add(new File(new File(edaHomeDir, "conf"), "edarc.xml"));
                    candidates.add(new File(new File(edaHomeDir, "etc"), "edarc.xml"));
                }
                candidates.add(LIB_CONFIG_FILE);
                candidates.add(ALT_LIB_CONFIG_FILE);
                boolean found = false;
                for (Object e : candidates) {
                    file = (File)e;
                    if (!file.exists()) continue;
                    found = true;
                    break;
                }
                if (found && file == alt) {
                    System.err.println("WARNING: Using older config file " + alt + "; rename to " + homedirfile + " as soon as possible.");
                }
                if (!found) {
                    return Configuration.getEmptyConfiguration();
                }
            }
            url = file.toURL();
        }
        return Configuration.getConfiguration(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getConfiguration(URL configFileUrl) throws SAXException, IOException {
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (configuration == null) {
                configuration = new Configuration(configFileUrl);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return configuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Configuration getEmptyConfiguration() {
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (configuration == null) {
                configuration = new Configuration();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return configuration;
        }
    }

    public static Configuration getConfigurationWithoutException() {
        if (configuration != null) {
            return configuration;
        }
        try {
            return Configuration.getConfiguration();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            System.err.println("Exception " + ex.getClass().getName() + " while getting configuration: " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    Configuration() {
        this.serverMgrPort = 7577;
        this.nameServerStateFrequency = 6000000;
        this.nameServerObjectKey = "StandardNS%20POA";
        this.nameServerPort = "10000";
        this.nameServerHost = "localhost";
        this.nameServerVersion = "1.0";
        this.nameServerUsingRIRProtocol = false;
        this.webServerDocumentDirectory = new File(System.getProperty("user.home", "/") + "tomcat/webapps/ROOT");
        this.webPort = "8080";
        this.webHost = "localhost";
        System.setProperty(WEB_PROTOCOL_PROPERTY, "http");
        this.initializeContext();
    }

    Configuration(URL url) throws IOException, SAXException {
        this(new InputSource(url.toString()));
    }

    Configuration(InputSource inputSource) throws IOException, SAXException {
        String systemID = inputSource.getSystemId();
        if (systemID == null) {
            inputSource.setSystemId("file:/unknown");
        }
        DOMParser parser = XML.createDOMParser();
        parser.setEntityResolver(new ConfigurationEntityResolver());
        parser.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException ex) throws SAXException {
                throw ex;
            }

            @Override
            public void warning(SAXParseException ex) {
                System.err.println("Warning: " + ex.getMessage());
            }

            @Override
            public void fatalError(SAXParseException ex) throws SAXException {
                System.err.println("Fatal parse error: " + ex.getMessage());
                throw ex;
            }
        });
        parser.parse(inputSource);
        Document document = parser.getDocument();
        XML.removeComments(document);
        document.normalize();
        if (!document.getDocumentElement().getNodeName().equals("configuration")) {
            throw new SAXException("Configuration " + inputSource.getSystemId() + " is not a <configuration> document");
        }
        NodeList list = document.getDocumentElement().getChildNodes();
        for (int eachChild = 0; eachChild < list.getLength(); ++eachChild) {
            int i;
            NodeList children;
            Node childNode = list.item(eachChild);
            if (childNode.getNodeName().equals("webServer")) {
                children = childNode.getChildNodes();
                for (i = 0; i < children.getLength(); ++i) {
                    Node node = children.item(i);
                    if ("host".equals(node.getNodeName())) {
                        this.webHost = XML.unwrappedText(node);
                        continue;
                    }
                    if ("port".equals(node.getNodeName())) {
                        this.webPort = XML.unwrappedText(node);
                        continue;
                    }
                    if (!"dir".equals(node.getNodeName())) continue;
                    this.webServerDocumentDirectory = new File(XML.unwrappedText(node));
                }
                this.properties.setProperty("org.apache.oodt.commons.Configuration.webServer.baseURL", this.getWebServerBaseURL());
                if (this.webServerDocumentDirectory != null) continue;
                this.webServerDocumentDirectory = new File(System.getProperty("user.home", "/") + "/dev/htdocs");
                continue;
            }
            if (childNode.getNodeName().equals("nameServer")) {
                NodeList children2;
                Element nameServerNode = (Element)childNode;
                String nameServerStateFrequencyString = nameServerNode.getAttribute("stateFrequency");
                if (nameServerStateFrequencyString == null || nameServerStateFrequencyString.length() == 0) {
                    this.nameServerStateFrequency = 0;
                } else {
                    try {
                        this.nameServerStateFrequency = Integer.parseInt(nameServerStateFrequencyString);
                    }
                    catch (NumberFormatException ex) {
                        throw new SAXException("Illegal nun-numeric value \"" + nameServerStateFrequencyString + "\" for stateFrequency attribute");
                    }
                }
                if (childNode.getFirstChild().getNodeName().equals("rir")) {
                    this.nameServerUsingRIRProtocol = true;
                    children2 = childNode.getFirstChild().getChildNodes();
                    this.nameServerObjectKey = children2.getLength() == 1 ? XML.unwrappedText(children2.item(0)) : null;
                    continue;
                }
                this.nameServerUsingRIRProtocol = false;
                this.nameServerVersion = null;
                this.nameServerPort = null;
                this.nameServerObjectKey = "StandardNS/NameServer%2DPOA/_root";
                children2 = childNode.getFirstChild().getChildNodes();
                for (int i2 = 0; i2 < children2.getLength(); ++i2) {
                    Node node = children2.item(i2);
                    if (node.getNodeName().equals("version")) {
                        this.nameServerVersion = XML.unwrappedText(node);
                        continue;
                    }
                    if (node.getNodeName().equals("host")) {
                        this.nameServerHost = XML.unwrappedText(node);
                        continue;
                    }
                    if (node.getNodeName().equals("port")) {
                        this.nameServerPort = XML.unwrappedText(node);
                        continue;
                    }
                    if (!node.getNodeName().equals("objectKey")) continue;
                    this.nameServerObjectKey = XML.unwrappedText(node);
                }
                continue;
            }
            if (childNode.getNodeName().equals("xml")) {
                children = childNode.getChildNodes();
                for (i = 0; i < children.getLength(); ++i) {
                    Node xmlNode = children.item(i);
                    if (!"entityRef".equals(xmlNode.getNodeName())) continue;
                    NodeList dirNodes = xmlNode.getChildNodes();
                    StringBuilder refDirs = new StringBuilder(System.getProperty(ENTITY_DIRS_PROP, ""));
                    for (int j = 0; j < dirNodes.getLength(); ++j) {
                        refDirs.append(',').append(XML.unwrappedText(dirNodes.item(j)));
                    }
                    if (refDirs.length() <= 0) continue;
                    System.setProperty(ENTITY_DIRS_PROP, refDirs.charAt(0) == ',' ? refDirs.substring(1) : refDirs.toString());
                }
                continue;
            }
            if ("serverMgr".equals(childNode.getNodeName())) {
                this.serverMgrPort = Integer.parseInt(XML.unwrappedText(childNode.getFirstChild()));
                continue;
            }
            if (childNode.getNodeName().equals("properties")) {
                Configuration.loadProperties(childNode, this.properties);
                continue;
            }
            if (!childNode.getNodeName().equals("programs")) continue;
            children = childNode.getChildNodes();
            for (i = 0; i < children.getLength(); ++i) {
                ExecServerConfig esc = new ExecServerConfig(children.item(i));
                esc.getProperties().setProperty("org.apache.oodt.commons.Configuration.url", inputSource.getSystemId());
                this.execServers.add(esc);
            }
        }
        this.initializeContext();
    }

    private void initializeContext() {
        this.contextEnvironment.put("java.naming.factory.initial", "org.apache.oodt.commons.object.jndi.ObjectCtxFactory");
        String registryList = System.getProperty("org.apache.oodt.commons.rmiregistries", System.getProperty("rmiregistries"));
        if (registryList == null) {
            String host = System.getProperty("rmiregistry.host", "localhost");
            int port = Integer.getInteger("rmiregistry.port", 1099);
            registryList = "rmi://" + host + ":" + port;
        }
        this.contextEnvironment.put("rmiregistries", registryList);
    }

    public String toXML() throws DOMException {
        Document doc = Configuration.createDocument("configuration");
        doc.replaceChild(this.toXML(doc), doc.getDocumentElement());
        return XML.serialize(doc);
    }

    public Node toXML(Document document) throws DOMException {
        Element configurationNode = document.createElement("configuration");
        Element webServerNode = document.createElement("webServer");
        configurationNode.appendChild(webServerNode);
        XML.add((Node)webServerNode, "host", this.webHost);
        XML.add((Node)webServerNode, "port", this.webPort);
        XML.add((Node)webServerNode, "dir", this.webServerDocumentDirectory.toString());
        Element nameServerNode = document.createElement("nameServer");
        nameServerNode.setAttribute("stateFrequency", String.valueOf(this.nameServerStateFrequency));
        configurationNode.appendChild(nameServerNode);
        if (this.nameServerUsingRIRProtocol) {
            Element rirNode = document.createElement("rir");
            nameServerNode.appendChild(rirNode);
            if (this.nameServerObjectKey != null) {
                XML.add((Node)rirNode, "objectKey", this.nameServerObjectKey);
            }
        } else {
            Element iiopNode = document.createElement("iiop");
            nameServerNode.appendChild(iiopNode);
            if (this.nameServerVersion != null) {
                XML.add((Node)iiopNode, "version", this.nameServerVersion);
            }
            XML.add((Node)iiopNode, "host", this.nameServerHost);
            if (this.nameServerPort != null) {
                XML.add((Node)iiopNode, "port", this.nameServerPort);
            }
            if (this.nameServerObjectKey != null) {
                XML.add((Node)iiopNode, "objectKey", this.nameServerObjectKey);
            }
        }
        if (!this.getEntityRefDirs().isEmpty()) {
            Element xmlNode = document.createElement("xml");
            configurationNode.appendChild(xmlNode);
            Element entityRefNode = document.createElement("entityRef");
            xmlNode.appendChild(entityRefNode);
            XML.add((Node)entityRefNode, "dir", this.getEntityRefDirs());
        }
        if (this.getServerMgrPort() != 0) {
            Element serverMgrNode = document.createElement("serverMgr");
            configurationNode.appendChild(serverMgrNode);
            XML.add((Node)serverMgrNode, "port", String.valueOf(this.getServerMgrPort()));
        }
        if (this.properties.size() > 0) {
            Configuration.dumpProperties(this.properties, configurationNode);
        }
        if (this.execServers.size() > 0) {
            Element programsNode = document.createElement("programs");
            configurationNode.appendChild(programsNode);
            for (Object execServer : this.execServers) {
                ExecServerConfig esc = (ExecServerConfig)execServer;
                Element execServerNode = document.createElement("execServer");
                programsNode.appendChild(execServerNode);
                XML.add((Node)execServerNode, "class", esc.getClassName());
                XML.add((Node)execServerNode, "objectKey", esc.getObjectKey());
                XML.add((Node)execServerNode, "host", esc.getPreferredHost().toString());
                if (esc.getProperties().size() <= 0) continue;
                Configuration.dumpProperties(esc.getProperties(), execServerNode);
            }
        }
        return configurationNode;
    }

    public void mergeProperties(Properties targetProps) {
        for (Map.Entry<Object, Object> objectObjectEntry : this.properties.entrySet()) {
            Map.Entry<Object, Object> entry = objectObjectEntry;
            if (targetProps.containsKey(entry.getKey())) continue;
            targetProps.put(entry.getKey(), entry.getValue());
        }
    }

    public Collection getExecServerConfigs() {
        return this.execServers;
    }

    public Collection getExecServerConfigs(Class clazz) {
        String className = clazz.getName();
        ArrayList<ExecServerConfig> execServerConfigs = new ArrayList<ExecServerConfig>();
        for (Object execServer : this.execServers) {
            ExecServerConfig exec = (ExecServerConfig)execServer;
            if (!className.equals(exec.getClassName())) continue;
            execServerConfigs.add(exec);
        }
        return execServerConfigs;
    }

    public ExecServerConfig getExecServerConfig(String objectKey) {
        ExecServerConfig execServerConfig = null;
        Iterator i = this.execServers.iterator();
        while (i.hasNext() && execServerConfig == null) {
            ExecServerConfig exec = (ExecServerConfig)i.next();
            if (!objectKey.equals(exec.getObjectKey())) continue;
            execServerConfig = exec;
        }
        return execServerConfig;
    }

    public String getWebServerBaseURL() {
        String proto = System.getProperty(WEB_PROTOCOL_PROPERTY);
        if (proto == null) {
            proto = "443".equals(this.webPort) ? "https" : "http";
        }
        return proto + "://" + this.webHost + ":" + this.webPort;
    }

    public File getWebServerDocumentDirectory() {
        return this.webServerDocumentDirectory;
    }

    public String getNameServerURL() {
        return this.getWebServerBaseURL() + "/ns.ior";
    }

    public String getNameServerPort() {
        return this.nameServerPort;
    }

    public int getNameServerStateFrequency() {
        return this.nameServerStateFrequency;
    }

    public Context getObjectContext() throws NamingException {
        Context c;
        String className = (String)this.contextEnvironment.get("java.naming.factory.initial");
        if (className == null) {
            c = new InitialContext(this.contextEnvironment);
        } else {
            try {
                Class<?> clazz = Class.forName(className);
                ClassLoader loader = clazz.getClassLoader();
                InitialContextThread thread = new InitialContextThread(loader);
                thread.start();
                try {
                    thread.join();
                }
                catch (InterruptedException ex) {
                    throw new NoInitialContextException("Initial context thread interrupted: " + ex.getMessage());
                }
                c = thread.getContext();
                if (c == null) {
                    throw thread.getException();
                }
            }
            catch (ClassNotFoundException ex) {
                throw new NoInitialContextException("Class " + className + " not found");
            }
        }
        return c;
    }

    public List getEntityRefDirs() {
        ArrayList<String> dirs = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(System.getProperty(ENTITY_DIRS_PROP, ""), ",;|");
        while (t.hasMoreTokens()) {
            dirs.add(t.nextToken());
        }
        return dirs;
    }

    public int getServerMgrPort() {
        return this.serverMgrPort;
    }

    static void loadProperties(Node propertiesNode, Properties props) {
        NodeList children = propertiesNode.getChildNodes();
        for (int i = 0; i < children.getLength(); i += 2) {
            String key = XML.unwrappedText(children.item(i));
            String value = XML.unwrappedText(children.item(i + 1));
            props.setProperty(key, value);
        }
    }

    static void dumpProperties(Properties props, Node node) {
        Element propertiesElement = node.getOwnerDocument().createElement("properties");
        node.appendChild(propertiesElement);
        Iterator<Map.Entry<Object, Object>> iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> objectObjectEntry;
            Map.Entry<Object, Object> entry = objectObjectEntry = iterator.next();
            XML.add((Node)propertiesElement, "key", (String)entry.getKey());
            XML.add((Node)propertiesElement, "value", (String)entry.getValue());
        }
    }

    static Document createDocument(String documentElementName) throws DOMException {
        DocumentType docType = XML.getDOMImplementation().createDocumentType(documentElementName, DTD_FPI, DTD_URL);
        return XML.getDOMImplementation().createDocument(null, documentElementName, docType);
    }

    private class InitialContextThread
    extends Thread {
        private Context context;
        private NamingException exception;

        public InitialContextThread(ClassLoader loader) {
            this.setContextClassLoader(loader);
        }

        @Override
        public void run() {
            try {
                this.context = new InitialContext(Configuration.this.contextEnvironment);
            }
            catch (NamingException ex) {
                this.exception = ex;
            }
            catch (Exception t) {
                System.err.println("Unexpected throwable " + t.getClass().getName() + " getting initial context: " + t.getMessage());
                t.printStackTrace();
            }
        }

        public Context getContext() {
            return this.context;
        }

        public NamingException getException() {
            return this.exception;
        }
    }
}

