/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.oodt.commons.Configuration;
import org.apache.oodt.commons.EDAException;
import org.apache.oodt.commons.Initializer;
import org.apache.oodt.commons.io.Base64EncodingOutputStream;
import org.apache.oodt.commons.util.LogInit;
import org.apache.oodt.commons.util.PropertyMgr;
import org.apache.oodt.commons.util.Utility;
import org.apache.oodt.commons.util.XML;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcServer;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.Servant;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ExecServer {
    public static final int MILLIS = 15000;
    private static Configuration configuration;
    protected String name;
    private Object servant;
    private String className;
    private static Binder binder;
    private Document statusDocument;
    private Element logElement;
    private XmlRpcServer xmlrpcServer;
    public static final String STATUS_FPI = "-//JPL//DTD EDA Server Status 1.0";
    public static final String STATUS_URL = "http://oodt.jpl.nasa.gov/edm-commons/xml/serverStatus.dtd";
    public static final String PRINT_IOR_PROPERTY = "org.apache.oodt.commons.ExecServer.printIOR";
    public static final String DISABLE_BINDING = "org.apache.oodt.commons.ExecServer.disableBinding";
    private static final long REBIND_PERIOD;

    public static void main(String[] argv) {
        if (argv.length < 2) {
            System.err.println("Usage: class-name-of-server object-name");
            System.exit(1);
        }
        String className = argv[0];
        String name = argv[1];
        System.setProperty("java.protocol.handler.pkgs", "org.apache.oodt.commons.net.protocol");
        try {
            configuration = Configuration.getConfiguration();
            configuration.mergeProperties(System.getProperties());
            LogInit.init(System.getProperties(), name);
            try {
                ExecServer.runInitializers();
            }
            catch (EDAException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
            final ExecServer server = new ExecServer(name, className);
            if (Boolean.getBoolean(PRINT_IOR_PROPERTY)) {
                if (server.getServant() instanceof RemoteObject) {
                    RemoteObject remoteObject = (RemoteObject)server.getServant();
                    RemoteStub remoteStub = (RemoteStub)RemoteObject.toStub(remoteObject);
                    RemoteRef ref = remoteStub.getRef();
                    System.out.print("RMI:");
                    System.out.flush();
                    ObjectOutputStream objOut = new ObjectOutputStream(new Base64EncodingOutputStream(System.out));
                    objOut.writeObject(ref);
                    objOut.flush();
                    System.out.println();
                } else {
                    Servant servant = (Servant)server.getServant();
                    ORB orb = servant._orb();
                    System.out.println(orb.object_to_string(servant._this_object(orb)));
                }
                System.out.flush();
            }
            if (!Boolean.getBoolean(DISABLE_BINDING)) {
                binder = new Binder(name, server);
                binder.start();
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    server.shutdown0();
                }
            });
            while (true) {
                try {
                    while (true) {
                        Thread.currentThread().join();
                    }
                }
                catch (InterruptedException servant) {
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            System.err.println("I/O error during initialization: " + ex.getMessage());
            ex.printStackTrace();
        }
        catch (SAXParseException ex) {
            System.err.println("Error in the configuration file at line " + ex.getLineNumber() + ", column " + ex.getColumnNumber() + ": " + ex.getMessage());
        }
        catch (SAXException ex) {
            System.err.println("Error " + ex.getClass().getName() + " while attempting to parse the configuration file: " + ex.getMessage());
        }
        catch (InvocationTargetException ex) {
            Throwable target = ex.getTargetException();
            System.err.println("Constructor for \"" + className + "\" threw " + target.getClass().getName() + ": " + ex.getMessage());
            target.printStackTrace();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            System.err.println("Exception " + ex.getClass().getName() + " initializing server \"" + name + "\" with class \"" + className + "\": " + ex.getMessage());
            ex.printStackTrace();
        }
        System.exit(1);
    }

    protected ExecServer(String name) {
        this.name = name;
    }

    public ExecServer(String name, String className) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, DOMException, UnknownHostException {
        this.name = name;
        Class<?> clazz = Class.forName(className);
        Constructor<?> ctor = clazz.getConstructor(ExecServer.class);
        this.servant = ctor.newInstance(this);
        Date startDate = new Date();
        this.xmlrpcServer = new XmlRpcServer();
        this.xmlrpcServer.addHandler("server", (Object)this);
        DocumentType docType = XML.getDOMImplementation().createDocumentType("server", STATUS_FPI, STATUS_URL);
        this.statusDocument = XML.getDOMImplementation().createDocument(null, "server", docType);
        Element serverElement = this.statusDocument.getDocumentElement();
        XML.add((Node)serverElement, "name", name);
        XML.add((Node)serverElement, "class", className);
        XML.add((Node)serverElement, "state", "up");
        Element startElement = this.statusDocument.createElement("start");
        serverElement.appendChild(startElement);
        Element userElement = this.statusDocument.createElement("user");
        startElement.appendChild(userElement);
        XML.add((Node)userElement, "name", System.getProperty("user.name", "UNKNOWN"));
        XML.add((Node)userElement, "cwd", System.getProperty("user.dir", "UNKNOWN"));
        XML.add((Node)userElement, "home", System.getProperty("user.home", "UNKNOWN"));
        Element dateElement = this.statusDocument.createElement("date");
        startElement.appendChild(dateElement);
        dateElement.setAttribute("ms", String.valueOf(startDate.getTime()));
        dateElement.appendChild(this.statusDocument.createTextNode(startDate.toString()));
        XML.add((Node)startElement, "config", System.getProperty("org.apache.oodt.commons.Configuration.url", "UNKNOWN"));
        Element hostElement = this.statusDocument.createElement("host");
        serverElement.appendChild(hostElement);
        XML.add((Node)hostElement, "name", InetAddress.getLocalHost().getHostName());
        Element osElement = this.statusDocument.createElement("os");
        hostElement.appendChild(osElement);
        XML.add((Node)osElement, "name", System.getProperty("os.name", "UNKNOWN"));
        XML.add((Node)osElement, "version", System.getProperty("os.version", "UNKNOWN"));
        XML.add((Node)osElement, "arch", System.getProperty("os.arch", "UNKNOWN"));
        Element vmElement = this.statusDocument.createElement("vm");
        serverElement.appendChild(vmElement);
        XML.add((Node)vmElement, "name", System.getProperty("java.vm.name", "UNKNOWN"));
        XML.add((Node)vmElement, "version", System.getProperty("java.version", "UNKNOWN"));
        XML.add((Node)vmElement, "classpath", System.getProperty("java.class.path", "UNKNOWN"));
        XML.add((Node)vmElement, "extdirs", System.getProperty("java.ext.dirs", "UNKNOWN"));
        this.logElement = this.statusDocument.createElement("log");
        serverElement.appendChild(this.logElement);
    }

    public String getName() {
        return this.name;
    }

    public Object getServant() {
        return this.servant;
    }

    public byte[] control(byte[] command) {
        return this.xmlrpcServer.execute((InputStream)new ByteArrayInputStream(command));
    }

    public String getServerClassName() {
        return this.className;
    }

    public String getServerStatus() {
        for (Object o : LogInit.MEMORY_LOGGER.getMessages()) {
            String message = (String)o;
            Element messageElement = this.statusDocument.createElement("message");
            messageElement.setAttribute("xml:space", "preserve");
            messageElement.appendChild(this.statusDocument.createTextNode(message));
            this.logElement.appendChild(messageElement);
        }
        String rc = XML.serialize(this.statusDocument);
        NodeList children = this.logElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.logElement.removeChild(children.item(i));
        }
        System.err.println(rc);
        return rc;
    }

    public int setSystemProperty(String key, String value) {
        System.err.println("Setting system property \"" + key + "\" to \"" + value + "\"");
        PropertyMgr.setProperty(key, value);
        return 0;
    }

    public Object callLocalServerManager(int port, String user, String password, String method, List params) throws IOException, XmlRpcException {
        XmlRpcClientLite local = new XmlRpcClientLite("localhost", port);
        local.setBasicAuthentication(user, password);
        return local.execute(method, new Vector(params));
    }

    public int shutdown() {
        System.err.println("Received shutdown command");
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(1);
            }
        }.start();
        this.shutdown0();
        System.err.println("Calling System.exit with status code 0");
        System.exit(0);
        return 0;
    }

    private void shutdown0() {
        if (!Boolean.getBoolean(DISABLE_BINDING)) {
            try {
                binder.stopBinding();
                Context objectContext = configuration.getObjectContext();
                objectContext.unbind(this.getName());
                objectContext.close();
            }
            catch (NamingException objectContext) {
                // empty catch block
            }
        }
        try {
            if (this.servant instanceof Servant) {
                Servant s = (Servant)this.servant;
                ORB orb = s._orb();
                orb.shutdown(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void runInitializers() throws EDAException {
        String initList = System.getProperty("org.apache.oodt.commons.initializers", System.getProperty("org.apache.oodt.commons.ExecServer.initializers", System.getProperty("initializers", "")));
        Iterator i = Utility.parseCommaList(initList);
        while (i.hasNext()) {
            String iname = (String)i.next();
            try {
                Class<?> initClass = Class.forName(iname);
                Initializer init = (Initializer)initClass.newInstance();
                init.initialize();
            }
            catch (ClassNotFoundException ex) {
                System.err.println("Initializer \"" + iname + "\" not found; aborting");
                throw new EDAException(ex);
            }
            catch (InstantiationException ex) {
                System.err.println("Initializer \"" + iname + "\" is abstract; aborting");
                throw new EDAException(ex);
            }
            catch (IllegalAccessException ex) {
                System.err.println("Initializer \"" + iname + "\" isn't public; aborting");
                throw new EDAException(ex);
            }
        }
    }

    static {
        REBIND_PERIOD = Long.getLong("org.apache.oodt.commons.ExecServer.rebindPeriod", 1800000L);
    }

    private static class Binder
    extends Thread {
        private boolean keepBinding;
        private String name;
        private ExecServer server;

        public Binder(String name, ExecServer server) {
            super("Binder for " + name);
            this.setDaemon(true);
            this.name = name;
            this.server = server;
            this.keepBinding = true;
        }

        @Override
        public void run() {
            while (this.shouldKeepBinding()) {
                try {
                    Context objectContext = configuration.getObjectContext();
                    objectContext.rebind(this.name, this.server.getServant());
                    objectContext.close();
                }
                catch (Exception ex) {
                    System.err.println("Exception binding at " + new Date() + "; will keep trying...");
                    ex.printStackTrace();
                }
                finally {
                    try {
                        Thread.sleep(REBIND_PERIOD);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public synchronized void stopBinding() {
            this.keepBinding = false;
        }

        private synchronized boolean shouldKeepBinding() {
            return this.keepBinding;
        }
    }
}

