/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.oodt.commons.Configuration;
import org.apache.oodt.commons.Executable;
import org.apache.oodt.commons.net.Net;
import org.apache.oodt.commons.util.Documentable;
import org.apache.oodt.commons.util.Utility;
import org.apache.oodt.commons.util.XML;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExecServerConfig
extends Executable
implements Documentable {
    private String className;
    private String objectKey;
    private Properties properties;
    private InetAddress preferredHost;
    private static String initialHeap;
    private static String maxHeap;

    public ExecServerConfig(String className, String objectKey, InetAddress preferredHost, Properties properties) {
        this.className = className;
        this.objectKey = objectKey;
        this.preferredHost = preferredHost;
        this.properties = properties;
    }

    public ExecServerConfig(Node xml) throws SAXException, UnknownHostException {
        this.properties = new Properties();
        this.preferredHost = Net.getLoopbackAddress();
        NodeList children = xml.getChildNodes();
        this.className = XML.unwrappedText(children.item(0));
        this.objectKey = XML.unwrappedText(children.item(1));
        for (int i = 2; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if ("host".equals(name)) {
                this.preferredHost = InetAddress.getByName(XML.unwrappedText(children.item(2)));
                continue;
            }
            if ("properties".equals(name)) {
                Configuration.loadProperties(child, this.properties);
                continue;
            }
            throw new SAXException("Unknown node " + name + " in exec server XML");
        }
    }

    public ExecServerConfig(String xml) throws SAXException, UnknownHostException {
        this(XML.parse(xml).getDocumentElement());
    }

    @Override
    protected String[] getCommandLine() {
        String[] commandLine = new String[6 + this.properties.size()];
        commandLine[0] = "java";
        commandLine[1] = "-Xms" + initialHeap;
        commandLine[2] = "-Xmx" + maxHeap;
        int index = 3;
        Iterator<Map.Entry<Object, Object>> iterator = this.properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> objectObjectEntry;
            Map.Entry<Object, Object> entry = objectObjectEntry = iterator.next();
            commandLine[index++] = "-D" + entry.getKey() + "=" + entry.getValue();
        }
        commandLine[index++] = "org.apache.oodt.commons.ExecServer";
        commandLine[index++] = this.className;
        commandLine[index++] = this.objectKey;
        return commandLine;
    }

    public String getClassName() {
        return this.className;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public InetAddress getPreferredHost() {
        return this.preferredHost;
    }

    public int hashCode() {
        return this.className.hashCode() ^ this.objectKey.hashCode() ^ this.properties.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        if (rhs == null || !(rhs instanceof ExecServerConfig)) {
            return false;
        }
        ExecServerConfig obj = (ExecServerConfig)rhs;
        return this.className.equals(obj.className) && this.objectKey.equals(obj.objectKey) && this.properties.equals(obj.properties);
    }

    public String toString() {
        return this.className + " " + this.objectKey;
    }

    @Override
    public Node toXML(Document doc) throws DOMException {
        Element execServerElement = doc.createElement("execServer");
        XML.add((Node)execServerElement, "class", this.getClassName());
        XML.add((Node)execServerElement, "objectKey", this.getObjectKey());
        XML.add((Node)execServerElement, "preferredHost", this.getPreferredHost().toString());
        Configuration.dumpProperties(this.getProperties(), execServerElement);
        return execServerElement;
    }

    public String toXML() throws DOMException {
        Document doc = Configuration.createDocument("execServer");
        doc.replaceChild(this.toXML(doc), doc.getDocumentElement());
        return XML.serialize(doc);
    }

    static {
        Properties props = new Properties();
        Utility.loadProperties(props, ExecServerConfig.class, "ExecServerConfig.properties");
        initialHeap = props.getProperty("initialHeap", "32m");
        maxHeap = props.getProperty("maxHeap", "128m");
    }
}

