/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Executable {
    public static final int INT = 1024;
    protected Process process;

    protected abstract String[] getCommandLine();

    public void execute() {
        new Thread(){

            @Override
            public void run() {
                try {
                    Executable.this.process = Runtime.getRuntime().exec(Executable.this.getCommandLine());
                    this.redirect(Executable.this.process.getErrorStream(), System.err);
                    this.redirect(Executable.this.process.getInputStream(), System.out);
                }
                catch (IOException ex) {
                    System.err.println("Can't execute command \"" + Executable.this.getCommandLine()[0] + "\": " + ex.getMessage());
                }
            }

            private void redirect(final InputStream in, final OutputStream out) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            byte[] buf = new byte[1024];
                            while (true) {
                                int numRead;
                                if ((numRead = in.read(buf)) == -1) {
                                    in.close();
                                    break;
                                }
                                out.write(buf, 0, numRead);
                            }
                        }
                        catch (IOException ex) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }.start();
            }
        }.start();
        while (this.process == null) {
            Thread.yield();
        }
    }

    public int waitFor() throws InterruptedException {
        return this.process.waitFor();
    }

    public void terminate() {
        this.process.destroy();
    }
}

