/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.server.RemoteObject;
import java.util.Hashtable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.oodt.commons.Configuration;
import org.apache.oodt.commons.ExecServer;
import org.apache.oodt.commons.util.LogInit;
import org.apache.oodt.commons.util.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MultiServer {
    public static final int BINDING = 1;
    public static final int NONBINDING = 2;
    public static final int REBINDING = 3;
    public static final int AUTO = 4;
    private static final Timer TIMER = new Timer(true);
    private static String appName;
    private static Map servers;
    private static Context context;
    private static final String CONFIG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE configuration PUBLIC \"-//JPL//DTD EDA Configuration 1.0//EN\" \"http://enterprise.jpl.nasa.gov/dtd/configuration.dtd\">\n<configuration><webServer><host>localhost</host><port>80</port></webServer><nameServer><iiop><host>localhost</host><port>10000</port></iiop></nameServer></configuration>";

    public static void main(String[] argv) throws Throwable {
        String config = System.getProperty("org.apache.oodt.commons.MultiServer.config", System.getProperty("MultiServer.config", System.getProperty("multiserver.config", System.getProperty("config"))));
        if (config == null) {
            if (argv.length != 1) {
                throw new IllegalStateException("No org.apache.oodt.commons.MultiServer.config property or config URL argument");
            }
            config = argv[0];
        }
        StringReader reader = new StringReader(CONFIG);
        Configuration.configuration = new Configuration(new InputSource(reader));
        reader.close();
        MultiServer.parseConfig(new InputSource(config));
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("java.naming.factory.initial", "org.apache.oodt.commons.object.jndi.ObjectCtxFactory");
        String registryList = System.getProperty("org.apache.oodt.commons.rmiregistries", System.getProperty("rmiregistries"));
        if (registryList == null) {
            String host = System.getProperty("rmiregistry.host", "localhost");
            int port = Integer.getInteger("rmiregistry.port", 1099);
            registryList = "rmi://" + host + ":" + port;
        }
        t.put("rmiregistries", registryList);
        context = NamingManager.getInitialContext(t);
        ExecServer.runInitializers();
        try {
            LogInit.init(System.getProperties(), MultiServer.getAppName());
            if (servers.isEmpty()) {
                throw new IllegalStateException("No servers defined in config");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    MultiServer.shutdown();
                }
            });
            MultiServer.startup();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                MultiServer.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(1);
        }
        while (true) {
            try {
                while (true) {
                    Thread.currentThread().join();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    static void parseConfig(InputSource is) throws ParserConfigurationException, SAXException, IOException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(is);
        Element root = doc.getDocumentElement();
        appName = root.getAttribute("id");
        if (appName == null) {
            throw new SAXException("id attribute missing from multiserver element");
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!"properties".equals(node.getNodeName())) continue;
            NodeList props = ((Element)node).getElementsByTagName("property");
            for (int j = 0; j < props.getLength(); ++j) {
                Element property = (Element)props.item(j);
                String name = property.getAttribute("name");
                if (System.getProperties().containsKey(name)) continue;
                String value = XML.unwrappedText(property);
                System.setProperty(name, value);
            }
        }
        NodeList serverNodes = root.getElementsByTagName("server");
        servers = new ConcurrentHashMap();
        for (int i = 0; i < serverNodes.getLength(); ++i) {
            Server server;
            Element serverElem = (Element)serverNodes.item(i);
            String name = serverElem.getAttribute("id");
            if (name == null) {
                throw new SAXException("id attribute missing from server element");
            }
            String className = serverElem.getAttribute("class");
            if (className == null) {
                throw new SAXException("class attribute missing from server element");
            }
            String bindKind = serverElem.getAttribute("bind");
            if (bindKind == null) {
                throw new SAXException("bind attribute missing from server element");
            }
            if ("true".equals(bindKind)) {
                server = new BindingServer(name, className);
            } else if ("false".equals(bindKind)) {
                server = new NonbindingServer(name, className);
            } else if ("rebind".equals(bindKind)) {
                server = new RebindingServer(name, className);
            } else {
                try {
                    long period = Long.parseLong(bindKind);
                    server = new AutobindingServer(name, className, period);
                }
                catch (NumberFormatException ex) {
                    throw new SAXException("Expected true, false, rebind, or auto for bind attribute but got `" + bindKind + "'");
                }
            }
            servers.put(name, server);
        }
    }

    static void startup() throws NamingException {
        for (Object o : servers.values()) {
            Server s = (Server)o;
            s.start();
        }
    }

    static void shutdown() {
        for (Object o : servers.values()) {
            try {
                Server s = (Server)o;
                s.stop();
            }
            catch (NamingException namingException) {}
        }
        TIMER.cancel();
    }

    static String getAppName() {
        return appName;
    }

    static Map getServers() {
        return servers;
    }

    static class AutobindingServer
    extends Server {
        private long period;
        private Binder binder;

        AutobindingServer(String name, String className, long period) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
            super(name, className);
            this.period = period;
        }

        @Override
        public int getBindingBehavior() {
            return 4;
        }

        @Override
        public void start() {
            this.binder = new Binder();
            TIMER.schedule((TimerTask)this.binder, 0L, this.period);
        }

        @Override
        public void stop() throws NamingException {
            if (this.binder != null) {
                this.binder.cancel();
            }
            context.unbind(this.name);
        }

        public long getPeriod() {
            return this.period;
        }

        private class Binder
        extends TimerTask {
            private Binder() {
            }

            @Override
            public void run() {
                try {
                    context.rebind(AutobindingServer.this.name, (Object)AutobindingServer.this.servant);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
    }

    static class RebindingServer
    extends BindingServer {
        RebindingServer(String name, String className) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
            super(name, className);
        }

        @Override
        public int getBindingBehavior() {
            return 3;
        }

        @Override
        public void start() throws NamingException {
            context.rebind(this.name, (Object)this.servant);
        }
    }

    static class NonbindingServer
    extends Server {
        NonbindingServer(String name, String className) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
            super(name, className);
        }

        @Override
        public int getBindingBehavior() {
            return 2;
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }
    }

    static class BindingServer
    extends Server {
        BindingServer(String name, String className) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
            super(name, className);
        }

        @Override
        public int getBindingBehavior() {
            return 1;
        }

        @Override
        public void start() throws NamingException {
            context.bind(this.name, (Object)this.servant);
        }

        @Override
        public void stop() throws NamingException {
            context.unbind(this.name);
        }
    }

    static abstract class Server
    extends ExecServer {
        protected String className;
        protected RemoteObject servant;

        protected Server(String name, String className) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
            super(name);
            this.className = className;
            Class<?> clazz = Class.forName(className);
            Constructor<?> ctor = clazz.getConstructor(ExecServer.class);
            this.servant = (RemoteObject)ctor.newInstance(this);
        }

        public String getClassName() {
            return this.className;
        }

        public abstract int getBindingBehavior();

        public abstract void start() throws NamingException;

        public abstract void stop() throws NamingException;
    }
}

