/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.activity;

import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Random;
import org.apache.oodt.commons.activity.ActivityStopped;
import org.apache.oodt.commons.activity.Incident;
import org.apache.oodt.commons.net.Net;

public abstract class Activity {
    public static final int INT = 32;
    public static final int INT1 = 255;
    protected String id;
    private boolean started = true;
    private static final Random RANDOM = new Random();
    private static long counter = 0L;

    protected Activity() {
        this.setID(this.generateID());
    }

    public void setID(String id) {
        if (id == null) {
            throw new IllegalArgumentException("ID required");
        }
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.log(new ActivityStopped());
    }

    public final synchronized void log(Incident incident) {
        incident.setActivityID(this.id);
        this.recordIncident(incident);
    }

    protected abstract void recordIncident(Incident var1);

    private String generateID() {
        try {
            InetAddress addr = Net.getLocalHost();
            long nextNum = ++counter;
            Date date = new Date();
            byte[] bytes = new byte[32];
            RANDOM.nextBytes(bytes);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update((String.valueOf(addr) + nextNum + date).getBytes());
            byte[] sig = messageDigest.digest(bytes);
            StringBuilder output = new StringBuilder();
            for (byte aSig : sig) {
                output.append(Integer.toHexString(aSig & 0xFF));
            }
            return output.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("MD5 algorithm not available");
        }
    }
}

