/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.activity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.apache.oodt.commons.activity.Activity;
import org.apache.oodt.commons.activity.ActivityFactory;
import org.apache.oodt.commons.activity.CompositeActivity;
import org.apache.oodt.commons.activity.NullActivity;

public class ActivityTracker {
    static ActivityFactory factory;

    public static Activity createActivity() {
        return factory.createActivity();
    }

    static void initializeFactories() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        String facNames = System.getProperty("org.apache.oodt.commons.activity.factories", System.getProperty("activity.factories", ""));
        ArrayList factories = new ArrayList();
        StringTokenizer tokens = new StringTokenizer(facNames, ",|");
        while (tokens.hasMoreTokens()) {
            String factoryName = tokens.nextToken();
            Class<?> factoryClass = Class.forName(factoryName);
            factories.add(factoryClass.newInstance());
        }
        factory = factories.isEmpty() ? new NullActivityFactory() : (factories.size() == 1 ? (ActivityFactory)factories.get(0) : new CompositeActivityFactory(factories));
    }

    static {
        try {
            ActivityTracker.initializeFactories();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot initialize activity factories: " + ex.getMessage());
        }
    }

    private static class CompositeActivityFactory
    implements ActivityFactory {
        private Collection factories;

        private CompositeActivityFactory(Collection factories) {
            this.factories = factories;
        }

        @Override
        public Activity createActivity() {
            ArrayList<Activity> activities = new ArrayList<Activity>();
            for (Object factory1 : this.factories) {
                ActivityFactory factory = (ActivityFactory)factory1;
                activities.add(factory.createActivity());
            }
            return new CompositeActivity(activities);
        }
    }

    private static class NullActivityFactory
    implements ActivityFactory {
        private NullActivityFactory() {
        }

        @Override
        public Activity createActivity() {
            return new NullActivity();
        }
    }
}

