/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.activity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.oodt.commons.activity.History;
import org.apache.oodt.commons.activity.Incident;
import org.apache.oodt.commons.activity.Storage;

class DatagramLogger {
    public static final int VAL = 4556;
    public static final int INT = 2048;
    private static Storage storage;
    private static Map histories;

    DatagramLogger() {
    }

    public static void main(String[] argv) throws Throwable {
        if (argv.length > 0) {
            System.err.println("This program takes NO command line arguments.");
            System.err.println("Set the activity.port property to adjust the port number.");
            System.err.println("Set the activity.storage property to set the Storage class to use.");
            System.exit(1);
        }
        int port = Integer.getInteger("activity.port", 4556);
        String className = System.getProperty("activity.storage");
        if (className == null) {
            System.err.println("No Storage class defined via the `activity.storage' property; exiting...");
            System.exit(1);
        }
        Class<?> storageClass = Class.forName(className);
        storage = (Storage)storageClass.newInstance();
        DatagramSocket socket = new DatagramSocket(port);
        byte[] buf = new byte[2048];
        DatagramPacket packet = new DatagramPacket(buf, buf.length);
        while (true) {
            socket.receive(packet);
            byte[] received = new byte[packet.getLength()];
            System.arraycopy(packet.getData(), packet.getOffset(), received, 0, packet.getLength());
            new ReceiverThread(received).start();
        }
    }

    static {
        histories = new ConcurrentHashMap();
    }

    private static class ReceiverThread
    extends Thread {
        private byte[] data;

        private ReceiverThread(byte[] data) {
            this.data = data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                History history;
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(this.data));
                Incident incident = (Incident)in.readObject();
                String id = incident.getActivityID();
                in.close();
                Map map = histories;
                synchronized (map) {
                    history = (History)histories.get(id);
                    if (history == null) {
                        histories.put(id, new History(incident, storage));
                        return;
                    }
                }
                history.addIncident(incident);
            }
            catch (ClassNotFoundException ex) {
                System.err.println("Dropping Incident of unknown class: " + ex.getMessage());
            }
            catch (InvalidClassException ex) {
                System.err.println("Dropping Incident of invalid class: " + ex.getMessage());
            }
            catch (StreamCorruptedException ex) {
                System.err.println("Unable to read Incident from packet: " + ex.getMessage());
            }
            catch (OptionalDataException ex) {
                System.err.println("Primitive data instead of Incident in packet: " + ex.getMessage());
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unexpected IOException: " + ex.getMessage());
            }
        }
    }
}

