/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.activity;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.oodt.commons.activity.Activity;
import org.apache.oodt.commons.activity.ActivityFactory;
import org.apache.oodt.commons.activity.Incident;

public class DatagramLoggingActivityFactory
implements ActivityFactory {
    public static final int VAL = 4556;
    InetAddress host;
    int port;
    DatagramSocket socket;

    public DatagramLoggingActivityFactory() {
        String hostname = System.getProperty("org.apache.oodt.commons.activity.DatagramLoggingActivityFactory.host", System.getProperty("activity.host", ""));
        this.port = Integer.getInteger("org.apache.oodt.commons.activity.DatagramLoggingActivityFactory.port", Integer.getInteger("activity.port", 4556));
        if (hostname.length() == 0) {
            throw new IllegalStateException("System property `org.apache.oodt.commons.activity.DatagramLoggingActivityFactory.host' (or simply `activity.host') not defined or is empty");
        }
        try {
            this.host = InetAddress.getByName(hostname);
            this.socket = new DatagramSocket();
        }
        catch (UnknownHostException ex) {
            throw new IllegalStateException("Activity host `" + this.host + "' unknown");
        }
        catch (SocketException ex) {
            throw new IllegalStateException("Cannot create anonymous datagram socket");
        }
    }

    @Override
    public Activity createActivity() {
        return new Activity(){

            @Override
            public void recordIncident(Incident incident) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(incident);
                    oos.close();
                    baos.close();
                    byte[] buf = baos.toByteArray();
                    DatagramPacket packet = new DatagramPacket(buf, buf.length, DatagramLoggingActivityFactory.this.host, DatagramLoggingActivityFactory.this.port);
                    DatagramLoggingActivityFactory.this.socket.send(packet);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
    }
}

