/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.activity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.oodt.commons.activity.ActivityStopped;
import org.apache.oodt.commons.activity.Incident;
import org.apache.oodt.commons.activity.Storage;

final class History {
    private String id;
    private Storage storage;
    private ExpireHistoryTask expireHistoryTask;
    private CloseHistoryTask closeHistoryTask;
    private List incidents = new ArrayList();
    private static final Timer TIMER = new Timer(true);
    static long idleTime = Long.getLong("org.apache.oodt.commons.activity.History.idle", 300000L);
    static long closeTime = Long.getLong("org.apache.oodt.commons.activity.History.close", 300000L);

    History(Incident initialIncident, Storage storage) {
        this.id = initialIncident.getActivityID();
        this.storage = storage;
        this.incidents.add(initialIncident);
        this.scheduleExpiration();
    }

    synchronized void addIncident(Incident incident) {
        if (!incident.getActivityID().equals(this.id)) {
            throw new IllegalArgumentException("Incident's activity ID " + incident.getActivityID() + " doesn't match History's ID " + this.id);
        }
        if (this.incidents == null) {
            return;
        }
        this.incidents.add(incident);
        if (this.expireHistoryTask != null) {
            this.expireHistoryTask.cancel();
        }
        if (incident instanceof ActivityStopped) {
            this.commit();
        } else if (this.closeHistoryTask == null) {
            this.scheduleExpiration();
        }
    }

    private void commit() {
        if (this.closeHistoryTask != null) {
            return;
        }
        this.closeHistoryTask = new CloseHistoryTask();
        TIMER.schedule((TimerTask)this.closeHistoryTask, closeTime);
    }

    private void scheduleExpiration() {
        this.expireHistoryTask = new ExpireHistoryTask();
        TIMER.schedule((TimerTask)this.expireHistoryTask, idleTime);
    }

    private synchronized void close() {
        Collections.sort(this.incidents);
        this.storage.store(this.id, this.incidents);
        this.incidents = null;
    }

    private class CloseHistoryTask
    extends TimerTask {
        private CloseHistoryTask() {
        }

        @Override
        public void run() {
            History.this.close();
        }
    }

    private class ExpireHistoryTask
    extends TimerTask {
        private ExpireHistoryTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            History history = History.this;
            synchronized (history) {
                if (History.this.expireHistoryTask == this) {
                    History.this.commit();
                }
            }
        }
    }
}

