/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.activity;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.oodt.commons.activity.ActivityException;
import org.apache.oodt.commons.activity.Retrieval;
import org.apache.oodt.commons.activity.StoredActivity;
import org.apache.oodt.commons.activity.StoredIncident;

public class SQLDatabaseRetrieval
implements Retrieval {
    private String driver = System.getProperty("org.apache.oodt.commons.activity.SQLDatabaseRetrieval.driver");
    private String url = System.getProperty("org.apache.oodt.commons.activity.SQLDatabaseRetrieval.url");
    private String user = System.getProperty("org.apache.oodt.commons.activity.SQLDatabaseRetrieval.user");
    private String password = System.getProperty("org.apache.oodt.commons.activity.SQLDatabaseRetrieval.password");
    private Connection connection;

    public SQLDatabaseRetrieval() {
        if (this.driver == null || this.url == null || this.user == null || this.password == null) {
            throw new IllegalStateException("SQLDatabaseRetrieval(): Required system properties `org.apache.oodt.commons.activity.SQLDatabaseRetrieval.[driver,url,user,password]' are not completely defined.");
        }
    }

    @Override
    public List retrieve() throws ActivityException {
        Connection conn = null;
        Statement stmt = null;
        ArrayList<StoredActivity> activities = new ArrayList<StoredActivity>();
        try {
            conn = this.openConnection();
            stmt = conn.createStatement();
            String sqlCmd = "SELECT activityID, className, occurTime, detail FROM incidents ORDER BY activityID, occurTime";
            String activityID = "";
            StoredActivity activity = null;
            ResultSet rs = stmt.executeQuery(sqlCmd);
            while (rs.next()) {
                String currActivityID = rs.getString(1);
                if (!activityID.equals(currActivityID)) {
                    activity = new StoredActivity(currActivityID);
                    activities.add(activity);
                    activityID = currActivityID;
                }
                activity.addIncident(new StoredIncident(rs.getString(2), rs.getLong(3), rs.getString(4)));
            }
            ArrayList<StoredActivity> arrayList = activities;
            return arrayList;
        }
        catch (ClassNotFoundException e) {
            throw new ActivityException("SQLDatabaseRetrieval.retrieve(): An exception occurred locating the JDBC driver class.", e);
        }
        catch (SQLException e) {
            throw new ActivityException("SQLDatabaseRetrieval.retrieve(): An exception occurred opening or accessing the database.", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private Connection openConnection() throws ClassNotFoundException, SQLException {
        Class.forName(this.driver);
        return DriverManager.getConnection(this.url, this.user, this.password);
    }

    public static void main(String[] argv) {
        try {
            SQLDatabaseRetrieval retrieval = new SQLDatabaseRetrieval();
            List activities = retrieval.retrieve();
            for (Object activity1 : activities) {
                StoredActivity activity = (StoredActivity)activity1;
                System.out.println("Activity: " + activity.getActivityID());
                List incidents = activity.getIncidents();
                for (Object incident1 : incidents) {
                    StoredIncident incident = (StoredIncident)incident1;
                    System.out.println("   Incident: " + incident.getClassName() + ", " + incident.getOccurTime() + ", " + incident.getDetail());
                }
            }
            System.exit(0);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String message = "";
            if (cause != null) {
                System.err.println(e.getMessage() + " Additional information: " + cause.getMessage());
            } else {
                System.err.println(e.getMessage());
            }
            System.exit(1);
        }
    }
}

