/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.activity;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.apache.oodt.commons.activity.Incident;
import org.apache.oodt.commons.activity.Storage;
import org.apache.oodt.commons.database.DatabaseConnectionBuilder;

public class SQLDatabaseStorage
implements Storage {
    private DataSource ds;

    public SQLDatabaseStorage() {
        String driver = System.getProperty("org.apache.oodt.commons.activity.SQLDatabaseStorage.driver");
        String url = System.getProperty("org.apache.oodt.commons.activity.SQLDatabaseStorage.url");
        String user = System.getProperty("org.apache.oodt.commons.activity.SQLDatabaseStorage.user");
        String password = System.getProperty("org.apache.oodt.commons.activity.SQLDatabaseStorage.password");
        if (driver == null || url == null || user == null || password == null) {
            throw new IllegalStateException("SQLDatabaseStorage(): Required system properties `org.apache.oodt.commons.activity.SQLDatabaseStorage.[driver,url,user,password]' are not completely defined.");
        }
        this.ds = DatabaseConnectionBuilder.buildDataSource(user, password, driver, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(String id, List incidents) {
        Statement statement = null;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            statement = conn.createStatement();
            for (Object incident1 : incidents) {
                Incident incident = (Incident)incident1;
                statement.executeUpdate("insert into incidents (activityID, className, occurTime, detail) values ('" + id + "', '" + incident.getClass().getName() + "', " + incident.getTime().getTime() + ", '" + SQLDatabaseStorage.escapeSingleQuote(incident.toString()) + "')");
            }
        }
        catch (SQLException e) {
            System.err.println("SQLDatabaseStorage.store(): Ignoring an exception that occurred while inserting a row into the database. Specifically, exception '" + e.getClass().getName() + "' occurred with message '" + e.getMessage() + "'");
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void finalize() throws Throwable {
        this.ds = null;
        super.finalize();
    }

    public static String escapeSingleQuote(String inputString) {
        int index = inputString.indexOf(39);
        if (index == -1) {
            return inputString;
        }
        String outputString = inputString;
        while (index != -1) {
            if (index == outputString.length() - 1 || outputString.charAt(index + 1) != '\'') {
                outputString = outputString.substring(0, index) + "'" + outputString.substring(index);
            }
            if (index + 2 <= outputString.length() - 1) {
                index = outputString.indexOf(39, index + 2);
                continue;
            }
            index = -1;
        }
        return outputString;
    }
}

