/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.database;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.oodt.commons.database.DatabaseConnectionBuilder;

public class SqlScript {
    private static Logger LOG = Logger.getLogger(SqlScript.class.getName());
    public static final char QUERY_ENDS = ';';
    private File script;
    private DataSource ds;
    private boolean useBatch = true;
    private List statementList = null;

    public SqlScript(String scriptFileName, DataSource ds) {
        this.script = new File(scriptFileName);
        this.statementList = new Vector();
        this.ds = ds;
    }

    public static void main(String[] args) {
        String usage = "SqlScript [options] </path/to/sql/file>\n--user <user>\n--pass <pass>\n--url <jdbc url>\n--driver <java class spec>\n";
        String user = null;
        String pass = null;
        String url = null;
        String driver = null;
        String sqlScriptFilePath = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--user")) {
                user = args[++i];
                continue;
            }
            if (args[i].equals("--pass")) {
                pass = args[++i];
                continue;
            }
            if (args[i].equals("--driver")) {
                driver = args[++i];
                continue;
            }
            if (args[i].equals("--url")) {
                url = args[++i];
                continue;
            }
            if (args[i].startsWith("--")) continue;
            sqlScriptFilePath = args[i];
        }
        if (user == null || pass == null || url == null || driver == null || sqlScriptFilePath == null) {
            System.err.println(usage);
            System.exit(1);
        }
        DataSource ds = DatabaseConnectionBuilder.buildDataSource(user, pass, driver, url);
        try {
            SqlScript sqlScript = new SqlScript(sqlScriptFilePath, ds);
            sqlScript.loadScript();
            sqlScript.execute();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadScript() throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.script));){
            String line;
            StringBuilder query = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (this.isComment(line)) continue;
                boolean queryEnds = this.checkStatementEnds(line);
                query.append(line);
                if (!queryEnds) continue;
                this.statementList.add(query.toString());
                query.setLength(0);
            }
        }
    }

    public void execute() {
        if (this.useBatch) {
            this.doExecuteBatch();
        } else if (this.statementList != null && this.statementList.size() > 0) {
            for (Object aStatementList : this.statementList) {
                String sqlStatement = (String)aStatementList;
                this.doExecuteIndividual(sqlStatement);
            }
        }
    }

    public boolean isUseBatch() {
        return this.useBatch;
    }

    public void setUseBatch(boolean useBatch) {
        this.useBatch = useBatch;
    }

    private boolean isComment(String line) {
        if (line != null && line.length() > 0) {
            return line.charAt(0) == '#';
        }
        return false;
    }

    private boolean checkStatementEnds(String s) {
        return s.indexOf(59) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteIndividual(String sql) {
        Connection conn = null;
        Statement statement = null;
        try {
            conn = this.ds.getConnection();
            statement = conn.createStatement();
            statement.execute(sql);
        }
        catch (SQLException e) {
            LOG.log(Level.SEVERE, e.getMessage());
            System.out.println("Exception executing SQL: [" + sql + "]: message: " + e.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteBatch() {
        Connection conn = null;
        Statement statement = null;
        try {
            if (this.statementList != null && this.statementList.size() > 0) {
                conn = this.ds.getConnection();
                statement = conn.createStatement();
                for (Object aStatementList : this.statementList) {
                    String sqlStatement = (String)aStatementList;
                    statement.addBatch(sqlStatement);
                }
                statement.executeBatch();
            }
        }
        catch (SQLException e) {
            LOG.log(Level.SEVERE, e.getMessage());
            System.out.println("Exception executing SQL batch statement: message: " + e.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

