/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.date;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.apache.oodt.commons.exceptions.CommonsException;

public class DateUtils {
    public static Calendar tai93epoch = new GregorianCalendar(1993, 0, 1);
    public static Calendar julianEpoch = new GregorianCalendar(1970, 0, 1);
    private static SimpleDateFormat utcFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static SimpleDateFormat taiFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static SimpleDateFormat localFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    static long[][] dateAndLeapSecs;

    private DateUtils() {
    }

    public static int getLeapSecsForDate(Calendar utcCal) throws CommonsException {
        long timeInMillis = utcCal.getTimeInMillis();
        for (int i = dateAndLeapSecs.length - 1; i >= 0; --i) {
            if (dateAndLeapSecs[i][IndexType.DATE.index] >= timeInMillis) continue;
            return (int)dateAndLeapSecs[i][IndexType.LEAP_SECS.index];
        }
        throw new CommonsException("No Leap Second found for given date!");
    }

    public static synchronized Calendar toTai(Calendar cal) throws CommonsException {
        Calendar taiCal = Calendar.getInstance(DateUtils.createTaiTimeZone(DateUtils.getLeapSecsForDate(cal)));
        taiCal.setTimeInMillis(cal.getTimeInMillis() + (long)(DateUtils.getLeapSecsForDate(cal) * 1000));
        return taiCal;
    }

    private static synchronized Calendar taiToUtc(Calendar taiCal) {
        Calendar calUtc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calUtc.setTimeInMillis(taiCal.getTimeInMillis() - (long)taiCal.getTimeZone().getRawOffset());
        return calUtc;
    }

    private static Calendar taiToLocal(Calendar taiCal) {
        return DateUtils.toLocal(DateUtils.taiToUtc(taiCal));
    }

    public static synchronized Calendar toLocal(Calendar cal) {
        if (cal.getTimeZone().getID().equals("TAI")) {
            return DateUtils.taiToLocal(cal);
        }
        Calendar calLocal = Calendar.getInstance();
        calLocal.setTimeInMillis(cal.getTimeInMillis());
        return calLocal;
    }

    public static synchronized Calendar toUtc(Calendar cal) {
        if (cal.getTimeZone().getID().equals("TAI")) {
            return DateUtils.taiToUtc(cal);
        }
        Calendar calUtc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calUtc.setTimeInMillis(cal.getTimeInMillis());
        return calUtc;
    }

    public static Calendar getCurrentUtcTime() {
        return DateUtils.toUtc(DateUtils.getCurrentLocalTime());
    }

    public static Calendar getCurrentLocalTime() {
        return Calendar.getInstance();
    }

    public static Calendar getCurrentTaiTime() throws CommonsException {
        return DateUtils.toTai(DateUtils.getCurrentUtcTime());
    }

    public static String toCustomLocalFormat(Calendar cal, String format) {
        return new SimpleDateFormat(format).format(cal.getTime());
    }

    public static String toString(Calendar cal) {
        String timeZoneId = cal.getTimeZone().getID();
        if (timeZoneId.equals("UTC")) {
            return utcFormat.format(cal.getTime());
        }
        if (timeZoneId.equals("TAI")) {
            return taiFormat.format(cal.getTime()) + "-0000" + cal.getTimeZone().getRawOffset() / 1000;
        }
        return localFormat.format(cal.getTime());
    }

    public static synchronized Calendar toLocalCustomFormatCalendar(String calString, String format) throws ParseException {
        Calendar localCal = Calendar.getInstance();
        localCal.setTime(new SimpleDateFormat(format).parse(calString));
        return localCal;
    }

    public static synchronized Calendar toCalendar(String calString, FormatType formatType) throws ParseException {
        Calendar cal = Calendar.getInstance();
        switch (formatType) {
            case LOCAL_FORMAT: {
                cal.setTimeInMillis(localFormat.parse(calString).getTime());
                break;
            }
            case TAI_FORMAT: {
                cal.setTimeZone(DateUtils.createTaiTimeZone(Integer.parseInt(calString.substring(calString.length() - 2))));
                calString = calString.substring(0, calString.length() - 5);
                cal.setTimeInMillis(taiFormat.parse(calString).getTime());
                break;
            }
            case UTC_FORMAT: {
                cal.setTimeZone(TimeZone.getTimeZone("UTC"));
                cal.setTimeInMillis(utcFormat.parse(calString).getTime());
                break;
            }
            default: {
                cal.setTimeInMillis(localFormat.parse(calString).getTime());
            }
        }
        return cal;
    }

    public static double getTimeInSecs(Calendar cal, Calendar epoch) throws CommonsException {
        return (double)DateUtils.getTimeInMillis(cal, epoch) / 1000.0;
    }

    public static String toString(double seconds) {
        return new DecimalFormat("#.000").format(seconds);
    }

    public static long getTimeInMillis(Calendar cal, Calendar epoch) throws CommonsException {
        long epochDiffInMilli = julianEpoch.getTimeZone().getID().equals("Europe/London") ? epoch.getTimeInMillis() - (julianEpoch.getTimeInMillis() + (long)julianEpoch.getTimeZone().getOffset(julianEpoch.getTimeInMillis())) : epoch.getTimeInMillis() - julianEpoch.getTimeInMillis();
        if (cal.getTimeZone().getID().equals("TAI")) {
            epochDiffInMilli += (long)(DateUtils.getLeapSecsForDate(epoch) * 1000);
        }
        long milliseconds = cal.getTimeInMillis();
        return milliseconds - epochDiffInMilli;
    }

    private static TimeZone createTaiTimeZone(int leapSecs) {
        return new SimpleTimeZone(leapSecs * 1000, "TAI");
    }

    public static void main(String[] args) throws ParseException, CommonsException {
        Calendar curTime = DateUtils.getCurrentLocalTime();
        System.out.println("Test Time: " + DateUtils.toString(DateUtils.toCalendar(DateUtils.toString(DateUtils.toTai(DateUtils.toCalendar("2008-01-20T16:29:55.000Z", FormatType.UTC_FORMAT))), FormatType.TAI_FORMAT)));
        System.out.println("Current Local Time: " + DateUtils.toString(curTime) + " " + curTime.getTimeInMillis());
        curTime = DateUtils.toCalendar("2008-01-20T16:29:55.000Z", FormatType.UTC_FORMAT);
        System.out.println("Current UTC Time: " + DateUtils.toString(curTime) + " " + DateUtils.toString(DateUtils.getTimeInSecs(curTime, tai93epoch)));
        curTime = DateUtils.toTai(DateUtils.toCalendar("2008-01-20T16:29:55.000Z", FormatType.UTC_FORMAT));
        System.out.println("Current TAI Time: " + DateUtils.toString(curTime) + " " + DateUtils.toString(DateUtils.getTimeInSecs(curTime, tai93epoch)));
        System.out.println("Current UTC Time: " + DateUtils.toString(DateUtils.taiToUtc(curTime)));
    }

    static {
        utcFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        taiFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateAndLeapSecs = new long[][]{{0L, 10L}, {new GregorianCalendar(1972, 6, 1).getTimeInMillis(), 11L}, {new GregorianCalendar(1973, 0, 1).getTimeInMillis(), 12L}, {new GregorianCalendar(1974, 0, 1).getTimeInMillis(), 13L}, {new GregorianCalendar(1975, 0, 1).getTimeInMillis(), 14L}, {new GregorianCalendar(1976, 0, 1).getTimeInMillis(), 15L}, {new GregorianCalendar(1977, 0, 1).getTimeInMillis(), 16L}, {new GregorianCalendar(1978, 0, 1).getTimeInMillis(), 17L}, {new GregorianCalendar(1979, 0, 1).getTimeInMillis(), 18L}, {new GregorianCalendar(1980, 0, 1).getTimeInMillis(), 19L}, {new GregorianCalendar(1981, 6, 1).getTimeInMillis(), 20L}, {new GregorianCalendar(1982, 6, 1).getTimeInMillis(), 21L}, {new GregorianCalendar(1983, 6, 1).getTimeInMillis(), 22L}, {new GregorianCalendar(1985, 6, 1).getTimeInMillis(), 23L}, {new GregorianCalendar(1988, 0, 1).getTimeInMillis(), 24L}, {new GregorianCalendar(1990, 0, 1).getTimeInMillis(), 25L}, {new GregorianCalendar(1991, 0, 1).getTimeInMillis(), 26L}, {new GregorianCalendar(1992, 6, 1).getTimeInMillis(), 27L}, {new GregorianCalendar(1993, 6, 1).getTimeInMillis(), 28L}, {new GregorianCalendar(1994, 6, 1).getTimeInMillis(), 29L}, {new GregorianCalendar(1996, 0, 1).getTimeInMillis(), 30L}, {new GregorianCalendar(1997, 6, 1).getTimeInMillis(), 31L}, {new GregorianCalendar(1999, 0, 1).getTimeInMillis(), 32L}, {new GregorianCalendar(2006, 0, 1).getTimeInMillis(), 33L}, {new GregorianCalendar(2009, 0, 1).getTimeInMillis(), 34L}};
    }

    static enum IndexType {
        DATE(0),
        LEAP_SECS(1);

        public int index;

        private IndexType(int index) {
            this.index = index;
        }
    }

    public static enum FormatType {
        UTC_FORMAT,
        LOCAL_FORMAT,
        TAI_FORMAT;

    }
}

