/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.exec;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class EnvUtilities {
    private static final Logger LOG = Logger.getLogger(EnvUtilities.class.getName());
    public static final int INT = 4096;
    private static final Properties environment = new Properties();

    private EnvUtilities() throws InstantiationException {
        throw new InstantiationException("Don't construct utility classes!");
    }

    public static String getEnv(String envVarName) {
        return environment.getProperty(envVarName);
    }

    public static Properties getEnv() {
        return environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getEnvUsingWaitFor() {
        String commandLine = "env";
        Process p = null;
        Properties envProps = null;
        try {
            p = Runtime.getRuntime().exec(commandLine);
            int retVal = p.waitFor();
            envProps = new Properties();
            envProps.load(EnvUtilities.preProcessInputStream(p.getInputStream()));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage());
            LOG.log(Level.WARNING, "Error executing env command: Message: " + e.getMessage());
        }
        finally {
            try {
                if (p.getErrorStream() != null) {
                    p.getErrorStream().close();
                }
            }
            catch (Exception exception) {}
            try {
                if (p.getInputStream() != null) {
                    p.getInputStream().close();
                }
            }
            catch (Exception exception) {}
            try {
                if (p.getOutputStream() != null) {
                    p.getOutputStream().close();
                }
            }
            catch (Exception exception) {}
        }
        return envProps;
    }

    public static String slurp(InputStream in) throws IOException {
        int n;
        StringBuilder out = new StringBuilder();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    protected static InputStream preProcessInputStream(InputStream is) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder buf = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            line = line.replaceAll("\\\\", "\\\\\\\\");
            buf.append(line).append("\n");
        }
        try {
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ByteArrayInputStream(buf.toString().getBytes());
    }

    static {
        System.getenv().entrySet();
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            environment.setProperty(entry.getKey(), entry.getValue());
        }
    }
}

