/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.exec;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.oodt.commons.exec.StreamGobbler;
import org.apache.oodt.commons.io.LoggerOutputStream;

public final class ExecUtils {
    private static Logger LOG = Logger.getLogger(ExecUtils.class.getName());

    private ExecUtils() throws InstantiationException {
        throw new InstantiationException("Don't construct utility classes!");
    }

    public static String printCommandLine(String[] args) {
        StringBuilder cmdLine = new StringBuilder();
        if (args != null && args.length > 0) {
            for (String arg : args) {
                cmdLine.append(arg);
                cmdLine.append(" ");
            }
        }
        return cmdLine.toString();
    }

    public static int callProgram(String commandLine, Logger logger) throws IOException {
        return ExecUtils.callProgram(commandLine, logger, null);
    }

    public static int callProgram(String commandLine, OutputStream stdOutStream, OutputStream stdErrStream) throws IOException {
        return ExecUtils.callProgram(commandLine, stdOutStream, stdErrStream, null);
    }

    public static int callProgram(String commandLine, Logger logger, File workDir) throws IOException {
        LoggerOutputStream loggerInfoStream = null;
        LoggerOutputStream loggerSevereStream = null;
        try {
            loggerInfoStream = new LoggerOutputStream(logger, Level.INFO);
            loggerSevereStream = new LoggerOutputStream(logger, Level.SEVERE);
            int n = ExecUtils.callProgram(commandLine, loggerInfoStream, loggerSevereStream, workDir);
            return n;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            try {
                if (loggerInfoStream != null) {
                    loggerInfoStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (loggerSevereStream != null) {
                    loggerSevereStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static int callProgram(String commandLine, OutputStream stdOutStream, OutputStream stdErrStream, File workDir) throws IOException {
        Process progProcess = null;
        StreamGobbler errorGobbler = null;
        StreamGobbler outputGobbler = null;
        int returnVal = -1;
        try {
            progProcess = workDir == null ? Runtime.getRuntime().exec(commandLine) : Runtime.getRuntime().exec(commandLine, null, workDir);
            errorGobbler = new StreamGobbler(progProcess.getErrorStream(), "ERROR", stdErrStream);
            outputGobbler = new StreamGobbler(progProcess.getInputStream(), "OUTPUT", stdOutStream);
            errorGobbler.start();
            outputGobbler.start();
            int n = returnVal = progProcess.waitFor();
            return n;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage());
            throw new IOException("Failed to run '" + commandLine + "' -- return val = " + returnVal + " : " + e.getMessage());
        }
        finally {
            if (errorGobbler != null) {
                errorGobbler.stopGobblingAndDie();
            }
            if (outputGobbler != null) {
                outputGobbler.stopGobblingAndDie();
            }
            try {
                if (progProcess != null) {
                    progProcess.getErrorStream().close();
                }
            }
            catch (Exception exception) {}
            try {
                if (progProcess != null) {
                    progProcess.getInputStream().close();
                }
            }
            catch (Exception exception) {}
            try {
                if (progProcess != null) {
                    progProcess.getOutputStream().close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static int callProgram(String commandLine, File workDir) throws IOException {
        Process p = Runtime.getRuntime().exec(commandLine, null, workDir);
        return ExecUtils.processProgram(p);
    }

    public static int callProgram(String[] args, File workDir) throws IOException {
        Process p = Runtime.getRuntime().exec(args, null, workDir);
        return ExecUtils.processProgram(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int processProgram(Process p) {
        StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), "ERROR", System.err);
        StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), "OUTPUT", System.out);
        errorGobbler.start();
        outputGobbler.start();
        int retVal = -1;
        try {
            retVal = p.waitFor();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (outputGobbler.isAlive()) {
                outputGobbler.stopGobblingAndDie();
            }
            if (errorGobbler.isAlive()) {
                errorGobbler.stopGobblingAndDie();
            }
            try {
                p.getErrorStream().close();
            }
            catch (Exception exception) {}
            try {
                p.getOutputStream().close();
            }
            catch (Exception exception) {}
            try {
                p.getInputStream().close();
            }
            catch (Exception exception) {}
        }
        return retVal;
    }
}

