/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.exec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamGobbler
extends Thread {
    private static final Logger LOG = Logger.getLogger(StreamGobbler.class.getName());
    InputStream is;
    String type;
    OutputStream os;
    private boolean running = true;

    public StreamGobbler(InputStream is, String type) {
        this(is, type, null);
    }

    public StreamGobbler(InputStream is, String type, OutputStream redirect) {
        this.is = is;
        this.type = type;
        this.os = redirect;
    }

    @Override
    public void run() {
        try {
            String line;
            PrintWriter pw = null;
            if (this.os != null) {
                pw = new PrintWriter(this.os);
            }
            InputStreamReader isr = new InputStreamReader(this.is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null && this.running) {
                if (pw == null) continue;
                pw.println(this.type + ": " + line);
            }
            if (pw != null) {
                pw.flush();
            }
        }
        catch (IOException ioe) {
            LOG.log(Level.FINEST, "StreamGobbler failed while gobbling : " + ioe.getMessage(), ioe);
        }
    }

    public void stopGobblingAndDie() {
        this.running = false;
    }
}

