/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.filter;

import java.util.Arrays;
import java.util.List;

public class TimeEvent
implements Comparable<TimeEvent> {
    protected long startTime;
    protected long endTime;
    protected long dur;
    protected double priority;

    public TimeEvent(long startTime, long endTime) {
        this(startTime, endTime, 0.0);
    }

    public TimeEvent(long startTime, long endTime, double priority) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.dur = this.endTime - this.startTime;
        this.priority = priority;
    }

    public void setPriority(double priority) {
        this.priority = priority;
    }

    public double getPriority() {
        return this.priority;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.dur;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeEvent) {
            TimeEvent te = (TimeEvent)obj;
            return te.startTime == this.startTime && te.endTime == this.endTime;
        }
        return false;
    }

    public String toString() {
        return "[" + this.startTime + "," + this.endTime + "] - " + this.priority;
    }

    public static boolean happenAtSameTime(TimeEvent te1, TimeEvent te2) {
        return te1.getStartTime() == te2.getStartTime() && te1.getEndTime() == te2.getEndTime();
    }

    @Override
    public int compareTo(TimeEvent te) {
        return Long.valueOf(this.startTime).compareTo(te.startTime);
    }

    public static List<? extends TimeEvent> getTimeOrderedEvents(List<? extends TimeEvent> events) {
        Object[] eventsArray = events.toArray(new TimeEvent[events.size()]);
        Arrays.sort(eventsArray);
        return Arrays.asList(eventsArray);
    }

    public int hashCode() {
        int result = (int)(this.startTime ^ this.startTime >>> 32);
        result = 31 * result + (int)(this.endTime ^ this.endTime >>> 32);
        result = 31 * result + (int)(this.dur ^ this.dur >>> 32);
        long temp = Double.doubleToLongBits(this.priority);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

