/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.oodt.commons.filter.TimeEvent;

public class TimeEventWeightedHash {
    private TimeEventNode root = new TimeEventNode(new TimeEvent(-1L, -1L));
    protected long epsilon;
    private MyLinkedHashSet<TimeEventNode> leafNodes = new MyLinkedHashSet();

    private TimeEventWeightedHash() {
        this.leafNodes.add(this.root);
    }

    public static TimeEventWeightedHash buildHash(List<? extends TimeEvent> events) {
        return TimeEventWeightedHash.buildHash(events, 0L);
    }

    public static TimeEventWeightedHash buildHash(List<? extends TimeEvent> events, long epsilon) {
        TimeEventWeightedHash hash = new TimeEventWeightedHash();
        hash.epsilon = epsilon;
        events = TimeEvent.getTimeOrderedEvents(events);
        for (TimeEvent timeEvent : events) {
            hash.addEvent(timeEvent);
        }
        return hash;
    }

    public List<? extends TimeEvent> getGreatestWeightedPathAsOrderedList() {
        LinkedList<TimeEvent> gwpEvents = new LinkedList<TimeEvent>();
        for (WeightedNode wn = this.getGreatestWeightedPath(); wn != null; wn = wn.getChild()) {
            gwpEvents.add(wn.getTimeEvent());
        }
        return gwpEvents;
    }

    private void addEvent(TimeEvent newEvent) {
        TimeEventNode newEventNode = new TimeEventNode(newEvent);
        MyLinkedHashSet<TimeEventNode> parentNodes = this.findParents(newEvent);
        MyLinkedHashSet<TimeEventNode> childrenNodes = this.findChildren(newEvent, parentNodes);
        if (childrenNodes.size() == 0) {
            this.leafNodes.add(newEventNode);
        }
        newEventNode.addParents(parentNodes);
        newEventNode.addChildren(childrenNodes);
    }

    private MyLinkedHashSet<TimeEventNode> findParents(TimeEvent newEvent) {
        MyLinkedHashSet<TimeEventNode> parentNodes = new MyLinkedHashSet<TimeEventNode>();
        MyLinkedHashSet<TimeEventNode> possibleParentNodes = new MyLinkedHashSet<TimeEventNode>();
        MyLinkedHashSet<TimeEventNode> possibleParentNodesAlreadyChecked = new MyLinkedHashSet<TimeEventNode>();
        TimeEventNode curPPN = this.root;
        while (curPPN != null) {
            boolean ppnListChanged = false;
            for (TimeEventNode curChild : curPPN.getChildren()) {
                if (!this.happensBefore(curChild.getTimeEvent(), newEvent) || possibleParentNodesAlreadyChecked.contains(curChild)) continue;
                possibleParentNodes.add(curChild);
                ppnListChanged = true;
            }
            if (!ppnListChanged) {
                parentNodes.add(curPPN);
            }
            possibleParentNodes.remove(curPPN);
            possibleParentNodesAlreadyChecked.add(curPPN);
            while ((curPPN = (TimeEventNode)possibleParentNodes.get(0)) != null && possibleParentNodesAlreadyChecked.contains(curPPN)) {
                possibleParentNodes.remove(curPPN);
            }
        }
        return parentNodes;
    }

    private MyLinkedHashSet<TimeEventNode> findChildren(TimeEvent newEvent, MyLinkedHashSet<TimeEventNode> parentNodes) {
        MyLinkedHashSet<TimeEventNode> childrenNodes = new MyLinkedHashSet<TimeEventNode>();
        MyLinkedHashSet<TimeEventNode> possibleChildrenNodes = new MyLinkedHashSet<TimeEventNode>();
        for (TimeEventNode parent : parentNodes) {
            possibleChildrenNodes.addAll(parent.getChildren());
            TimeEventNode curPCN = (TimeEventNode)possibleChildrenNodes.get(0);
            while (curPCN != null && !parentNodes.contains(curPCN)) {
                if (this.happensBefore(newEvent, curPCN.getTimeEvent())) {
                    childrenNodes.add(curPCN);
                } else {
                    possibleChildrenNodes.addAll(curPCN.getChildren());
                }
                possibleChildrenNodes.remove(curPCN);
                curPCN = (TimeEventNode)possibleChildrenNodes.get(0);
            }
        }
        return childrenNodes;
    }

    private boolean happensBefore(TimeEvent t1, TimeEvent t2) {
        long boundaryCheck = t2.getStartTime() - t1.getEndTime();
        return t1.getStartTime() < t2.getStartTime() && boundaryCheck + this.epsilon > 0L;
    }

    private WeightedNode getGreatestWeightedPath() {
        TimeEventNode max = this.leafNodes.get(0);
        for (TimeEventNode ten : this.leafNodes) {
            if (ten.getPathWeight() <= max.getPathWeight() && (ten.getPathWeight() != max.getPathWeight() || !(ten.getPathPriorityWeight() > max.getPathPriorityWeight()))) continue;
            max = ten;
        }
        WeightedNode root = new WeightedNode(max.getTimeEvent());
        TimeEventNode curTEN = max.greatestWieghtedParent;
        while (curTEN != null) {
            WeightedNode temp = new WeightedNode(curTEN.getTimeEvent());
            temp.setChild(root);
            root = temp;
            curTEN = curTEN.greatestWieghtedParent;
        }
        return root.getChild();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        LinkedList<TimeEventNode> printNodes = new LinkedList<TimeEventNode>();
        printNodes.add(this.root);
        sb.append(this.printNodes(printNodes, "-", 0L));
        return sb.toString();
    }

    private StringBuffer printNodes(List<TimeEventNode> list, String spacer, long curPathWeight) {
        StringBuffer output = new StringBuffer("");
        for (TimeEventNode node : list) {
            output.append(spacer);
            output.append(node.te).append(" -- ").append(curPathWeight + node.te.getDuration()).append("\n");
            output.append(this.printNodes(node.getChildren().getList(), " " + spacer, curPathWeight + node.te.getDuration()));
        }
        return output;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeEventWeightedHash that = (TimeEventWeightedHash)o;
        if (this.epsilon != that.epsilon) {
            return false;
        }
        if (this.root != null ? !this.root.equals(that.root) : that.root != null) {
            return false;
        }
        return !(this.leafNodes == null ? that.leafNodes != null : !this.leafNodes.equals(that.leafNodes));
    }

    public int hashCode() {
        int result = this.root != null ? this.root.hashCode() : 0;
        result = 31 * result + (int)(this.epsilon ^ this.epsilon >>> 32);
        result = 31 * result + (this.leafNodes != null ? this.leafNodes.hashCode() : 0);
        return result;
    }

    private class WeightedNode {
        private long pathWeight;
        private WeightedNode child;
        private TimeEvent te;

        private WeightedNode(TimeEvent te) {
            this.te = te;
            this.pathWeight = te.getDuration();
        }

        private void setChild(WeightedNode child) {
            this.child = child;
            if (child != null) {
                this.pathWeight = this.te.getDuration() + child.getPathWeight();
            }
        }

        public TimeEvent getTimeEvent() {
            return this.te;
        }

        public WeightedNode getChild() {
            return this.child;
        }

        public long getPathWeight() {
            return this.pathWeight;
        }

        public String toString() {
            return this.te.toString() + "\n" + (this.child != null ? this.child.toString() : "");
        }
    }

    private class TimeEventNode {
        private TimeEvent te;
        private MyLinkedHashSet<TimeEventNode> children;
        private MyLinkedHashSet<TimeEventNode> parents;
        private TimeEventNode greatestWieghtedParent;

        public TimeEventNode(TimeEvent te) {
            this.te = te;
            this.children = new MyLinkedHashSet();
            this.parents = new MyLinkedHashSet();
        }

        public long getPathWeight() {
            if (this.greatestWieghtedParent != null) {
                return this.te.getDuration() + this.greatestWieghtedParent.getPathWeight();
            }
            return this.te.getDuration();
        }

        public double getPathPriorityWeight() {
            if (this.greatestWieghtedParent != null) {
                return this.te.getPriority() + this.greatestWieghtedParent.getPathPriorityWeight();
            }
            return this.te.getPriority();
        }

        public TimeEvent getTimeEvent() {
            return this.te;
        }

        public void setTimeEvent(TimeEvent te) {
            this.te = te;
        }

        public void addChild(TimeEventNode child) {
            for (TimeEventNode parent : this.parents) {
                parent.children.remove(child);
                child.parents.remove(parent);
            }
            this.children.add(child);
            child.parents.add(this);
            TimeEventWeightedHash.this.leafNodes.remove(this);
            child.greatestWieghtedParent = this;
            for (TimeEventNode parent : child.parents) {
                long gwpPaW = child.greatestWieghtedParent.getPathWeight();
                long pPaW = parent.getPathWeight();
                double gwpPiW = child.greatestWieghtedParent.getPathPriorityWeight();
                double pPiW = parent.getPathPriorityWeight();
                if (pPaW <= gwpPaW && (pPaW != gwpPaW || !(pPiW > gwpPiW))) continue;
                child.greatestWieghtedParent = parent;
            }
        }

        public void addParent(TimeEventNode parent) {
            parent.addChild(this);
        }

        public void addChildren(Collection<TimeEventNode> children) {
            for (TimeEventNode child : children) {
                this.addChild(child);
            }
        }

        public void addParents(Collection<TimeEventNode> parents) {
            for (TimeEventNode parent : parents) {
                this.addParent(parent);
            }
        }

        public MyLinkedHashSet<TimeEventNode> getChildren() {
            return this.children;
        }

        public MyLinkedHashSet<TimeEventNode> getParents() {
            return this.parents;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TimeEventNode) {
                TimeEventNode ten = (TimeEventNode)obj;
                return this.te.equals(ten.te);
            }
            return false;
        }

        public String toString() {
            return this.te.toString() + " -- " + this.getPathWeight();
        }
    }

    private class MyLinkedHashSet<E>
    extends HashSet<E> {
        private static final long serialVersionUID = -7319154087430025841L;
        private LinkedList<E> listSet = new LinkedList();

        @Override
        public boolean add(E ten) {
            boolean wasAdded = super.add(ten);
            if (wasAdded) {
                this.listSet.add(ten);
            }
            return wasAdded;
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            boolean setChanged = false;
            for (E ten : collection) {
                if (!this.add(ten)) continue;
                setChanged = true;
            }
            return setChanged;
        }

        @Override
        public boolean remove(Object ten) {
            if (super.remove(ten)) {
                this.listSet.remove(ten);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean setChanged = false;
            for (Object obj : collection) {
                if (!this.remove(obj)) continue;
                setChanged = true;
            }
            return setChanged;
        }

        public E get(int index) {
            if (this.listSet.size() > index) {
                return this.listSet.get(index);
            }
            return null;
        }

        public List<E> getList() {
            return this.listSet;
        }
    }
}

