/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.oodt.commons.util.Base64;

public class Base64DecodingInputStream
extends FilterInputStream {
    private byte[] buffer;
    private int index = 3;

    public Base64DecodingInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int read() throws IOException {
        if (this.in == null) {
            throw new IOException("Can't read from a closed stream");
        }
        if (this.buffer == null || this.index == this.buffer.length) {
            int actuallyGot;
            byte[] streamBuf = new byte[4];
            int atIndex = 0;
            boolean firstRead = true;
            for (int toRead = 4; toRead > 0; toRead -= actuallyGot) {
                actuallyGot = this.in.read(streamBuf, atIndex, toRead);
                if (actuallyGot == -1) {
                    if (!firstRead) break;
                    return -1;
                }
                firstRead = false;
                atIndex += actuallyGot;
            }
            this.buffer = Base64.decode(streamBuf);
            if (this.buffer.length == 0) {
                this.buffer = null;
                return -1;
            }
            this.index = 0;
        }
        return this.buffer[this.index++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int i;
        if (b == null) {
            throw new IllegalArgumentException("Can't read data into a null array");
        }
        if (offset < 0 || offset >= b.length) {
            throw new IndexOutOfBoundsException("Can't read data into an array with indexes 0.." + (b.length - 1) + " at index " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Can't read a negative amount of data");
        }
        if (offset + length > b.length) {
            throw new IndexOutOfBoundsException("Can't read data past the right edge of an array");
        }
        if (this.in == null) {
            throw new IOException("Can't read from a closed stream");
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[offset] = (byte)c;
        try {
            for (i = 1; i < length && (c = this.read()) != -1; ++i) {
                b[offset + i] = (byte)c;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return i;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.in == null) {
            throw new IOException("Can't skip past data on a closed stream");
        }
        int actuallySkipped = 0;
        while (n > 0L) {
            if (this.read() == -1) {
                return actuallySkipped;
            }
            --n;
            ++actuallySkipped;
        }
        return actuallySkipped;
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            throw new IOException("Can't see how many bytes are available on a closed stream");
        }
        if (this.buffer != null && this.index < this.buffer.length) {
            return this.buffer.length - this.index;
        }
        return this.in.available() >= 4 ? 1 : 0;
    }

    @Override
    public void close() throws IOException {
        if (this.in == null) {
            throw new IOException("Can't close a closed stream");
        }
        this.in.close();
        this.in = null;
        this.buffer = null;
    }
}

