/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.oodt.commons.util.Base64;

public class Base64EncodingOutputStream
extends FilterOutputStream {
    private static final int BUFFER_SIZE = 300;
    private byte[] buffer = new byte[300];
    private int index = 0;

    public Base64EncodingOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buffer == null) {
            throw new IOException("Can't write onto a closed stream");
        }
        this.buffer[this.index++] = (byte)b;
        if (this.index == this.buffer.length) {
            this.shipout();
        }
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        if (b == null) {
            throw new IllegalArgumentException("Can't write a null array");
        }
        if (offset < 0 || offset >= b.length) {
            throw new IndexOutOfBoundsException("Can't get bytes at " + offset + " in array with indexes 0.." + (b.length - 1));
        }
        if (length < 0) {
            throw new IllegalArgumentException("Can't write a negative amount of bytes");
        }
        if (offset + length > b.length) {
            throw new IndexOutOfBoundsException("Can't get bytes beyond edge of array");
        }
        if (this.buffer == null) {
            throw new IOException("Can't write onto a closed stream");
        }
        while (length > 0) {
            int avail = this.buffer.length - this.index;
            int amount = avail < length ? avail : length;
            System.arraycopy(b, offset, this.buffer, this.index, amount);
            this.index += amount;
            offset += amount;
            length -= amount;
            if (this.index != this.buffer.length) continue;
            this.shipout();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.buffer == null) {
            throw new IOException("Can't flush a closed stream");
        }
        this.shipout();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.buffer == null) {
            throw new IOException("Can't close an already closed stream");
        }
        this.flush();
        this.out.close();
        this.out = null;
        this.buffer = null;
    }

    private void shipout() throws IOException {
        byte[] encoded = Base64.encode(this.buffer, 0, this.index);
        this.out.write(encoded);
        this.index = 0;
    }
}

