/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends FilterOutputStream {
    private long written = 0L;

    public CountingOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.written;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.written += (long)b.length;
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        this.out.write(b, offset, length);
        this.written += (long)length;
    }

    public long getBytesWritten() {
        return this.written;
    }
}

