/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.io;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

public class DirectorySelector {
    private List<String> files;
    private FileFilter directoryFilter;

    public DirectorySelector(List<String> files) {
        this.files = files;
        this.directoryFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
    }

    public List<String> traverseDir(File rootDir) {
        ArrayList<String> subDirs = new ArrayList<String>();
        if (rootDir.exists() && this.files != null && this.files.size() > 0) {
            this.traverseDir(rootDir, subDirs);
        }
        return subDirs;
    }

    private void traverseDir(File dir, List<String> subDirs) {
        File[] subdirs;
        boolean include = true;
        for (String file : this.files) {
            File requiredFile = new File(dir, file);
            if (requiredFile.exists()) continue;
            include = false;
        }
        if (include) {
            subDirs.add("file://" + dir.getAbsolutePath());
        }
        if ((subdirs = dir.listFiles(this.directoryFilter)) != null) {
            for (File subdir : subdirs) {
                this.traverseDir(subdir, subDirs);
            }
        }
    }
}

