/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.io;

import java.io.IOException;
import java.io.OutputStream;

public class FixedBufferOutputStream
extends OutputStream {
    private int length;
    private int size;
    private int start;
    private byte[] buffer;

    public FixedBufferOutputStream(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Buffer size must be nonnegative");
        }
        this.buffer = new byte[n];
        this.length = n;
        this.size = 0;
        this.start = 0;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkIfClosed();
        if (this.length == 0) {
            return;
        }
        if (this.size < this.length) {
            this.buffer[this.size++] = (byte)b;
        } else {
            this.buffer[this.start] = (byte)b;
            this.start = (this.start + 1) % this.length;
        }
    }

    @Override
    public void write(byte[] a, int off, int len) throws IOException {
        this.checkIfClosed();
        if (a == null) {
            throw new NullPointerException("Can't write from a null array");
        }
        if (off < 0 || off > a.length || len < 0 || off + len > a.length || off + len < 0) {
            throw new IndexOutOfBoundsException("Offset " + off + " and length " + len + " not within array bounds");
        }
        if (len == 0) {
            return;
        }
        if (len > this.length) {
            off += len - this.length;
            len = this.length;
        }
        int capacity = this.length - this.size;
        int insertionIndex = this.size < this.length ? this.size : this.start;
        int insertionLength = Math.min(this.length - insertionIndex, len);
        int remaining = len - insertionLength;
        System.arraycopy(a, off, this.buffer, insertionIndex, insertionLength);
        if (remaining > 0) {
            System.arraycopy(a, off + insertionLength, this.buffer, 0, remaining);
            this.start = remaining;
        } else if (capacity == 0) {
            this.start = insertionIndex + insertionLength;
        }
        this.size = Math.min(this.length, this.size + len);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.start = -1;
    }

    public byte[] getBuffer() {
        byte[] rc = new byte[Math.min(this.size, this.length)];
        System.arraycopy(this.buffer, this.start, rc, 0, this.size - this.start);
        System.arraycopy(this.buffer, 0, rc, this.size - this.start, this.start);
        return rc;
    }

    private void checkIfClosed() throws IOException {
        if (this.start == -1) {
            throw new IOException("Can't write to closed stream");
        }
    }
}

