/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.io;

import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.oodt.commons.io.LogEvent;
import org.apache.oodt.commons.io.LogListener;
import org.apache.oodt.commons.io.LogWriter;

public class Log {
    private static Vector listeners = new Vector();
    private static String defaultSource;
    private static Object defaultCategory;
    private static LogWriter lastWriter;

    public static LogWriter get() {
        if (lastWriter != null && !lastWriter.isFlushed()) {
            return lastWriter;
        }
        return Log.get(new Date(), Log.getDefaultSource(), Log.getDefaultCategory());
    }

    public static LogWriter get(Object category) {
        return Log.get(new Date(), Log.getDefaultSource(), category);
    }

    public static synchronized LogWriter get(Date timestamp, String source, Object category) {
        lastWriter = new LogWriter(timestamp, source, category);
        return lastWriter;
    }

    public static void startStream(String stream, Date timestamp, String source) {
        LogEvent event = null;
        Enumeration e = listeners.elements();
        while (e.hasMoreElements()) {
            if (event == null) {
                event = new LogEvent(stream, timestamp, source);
            }
            ((LogListener)e.nextElement()).streamStarted(event);
        }
    }

    public static void stopStream(String stream) {
        LogEvent event = null;
        Enumeration e = listeners.elements();
        while (e.hasMoreElements()) {
            if (event == null) {
                event = new LogEvent(stream);
            }
            ((LogListener)e.nextElement()).streamStopped(event);
        }
    }

    static void logMessage(Date timestamp, String source, Object category, String message) {
        LogEvent event = null;
        Enumeration e = listeners.elements();
        while (e.hasMoreElements()) {
            if (event == null) {
                event = new LogEvent(timestamp, source, category, message);
            }
            ((LogListener)e.nextElement()).messageLogged(event);
        }
    }

    public static void setDefaultSource(String source) {
        if (source == null) {
            throw new IllegalArgumentException("Can't set a null default source");
        }
        defaultSource = source;
    }

    public static String getDefaultSource() {
        return defaultSource;
    }

    public static void setDefaultCategory(Object category) {
        if (category == null) {
            throw new IllegalArgumentException("Can't set a null default category");
        }
        defaultCategory = category;
    }

    public static Object getDefaultCategory() {
        return defaultCategory;
    }

    public static void addLogListener(LogListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Can't add a null log listener");
        }
        listeners.addElement(listener);
    }

    public static void removeLogListener(LogListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Can't remove a null log listener");
        }
        listeners.removeElement(listener);
    }

    private Log() {
    }

    static {
        String loggers = System.getProperty("org.apache.oodt.commons.io.Log.loggers", "");
        StringTokenizer tokenizer = new StringTokenizer(loggers);
        while (tokenizer.hasMoreTokens()) {
            String className = tokenizer.nextToken();
            try {
                Class<?> clazz = Class.forName(className);
                LogListener listener = (LogListener)clazz.newInstance();
                Log.addLogListener(listener);
            }
            catch (Exception e) {
                System.err.println("Can't create log listener object from class " + className + ": " + e);
                System.exit(1);
            }
        }
        defaultSource = "app";
        defaultCategory = "message";
    }
}

